<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTaskAction StructType
 * @subpackage Structs
 */
class WSTaskAction extends AbstractStructBase
{
    /**
     * The actionNotice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $actionNotice;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSGeoPoint
     */
    public $location;
    /**
     * The nextStepIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $nextStepIndex;
    /**
     * The nextStepInputs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSTaskInput
     */
    public $nextStepInputs;
    /**
     * The nextStepTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $nextStepTarget;
    /**
     * The personId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $personId;
    /**
     * The stepInputs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSTaskInput
     */
    public $stepInputs;
    /**
     * The taskId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $taskId;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $timestamp;
    /**
     * Constructor method for WSTaskAction
     * @uses WSTaskAction::setActionNotice()
     * @uses WSTaskAction::setLocation()
     * @uses WSTaskAction::setNextStepIndex()
     * @uses WSTaskAction::setNextStepInputs()
     * @uses WSTaskAction::setNextStepTarget()
     * @uses WSTaskAction::setPersonId()
     * @uses WSTaskAction::setStepInputs()
     * @uses WSTaskAction::setTaskId()
     * @uses WSTaskAction::setTimestamp()
     * @param string $actionNotice
     * @param \StructType\WSGeoPoint $location
     * @param int $nextStepIndex
     * @param \ArrayType\ArrayOfWSTaskInput $nextStepInputs
     * @param int $nextStepTarget
     * @param int $personId
     * @param \ArrayType\ArrayOfWSTaskInput $stepInputs
     * @param int $taskId
     * @param \StructType\WSTimestamp $timestamp
     */
    public function __construct($actionNotice = null, \StructType\WSGeoPoint $location = null, $nextStepIndex = null, \ArrayType\ArrayOfWSTaskInput $nextStepInputs = null, $nextStepTarget = null, $personId = null, \ArrayType\ArrayOfWSTaskInput $stepInputs = null, $taskId = null, \StructType\WSTimestamp $timestamp = null)
    {
        $this
            ->setActionNotice($actionNotice)
            ->setLocation($location)
            ->setNextStepIndex($nextStepIndex)
            ->setNextStepInputs($nextStepInputs)
            ->setNextStepTarget($nextStepTarget)
            ->setPersonId($personId)
            ->setStepInputs($stepInputs)
            ->setTaskId($taskId)
            ->setTimestamp($timestamp);
    }
    /**
     * Get actionNotice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionNotice()
    {
        return isset($this->actionNotice) ? $this->actionNotice : null;
    }
    /**
     * Set actionNotice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionNotice
     * @return \StructType\WSTaskAction
     */
    public function setActionNotice($actionNotice = null)
    {
        // validation for constraint: string
        if (!is_null($actionNotice) && !is_string($actionNotice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionNotice, true), gettype($actionNotice)), __LINE__);
        }
        if (is_null($actionNotice) || (is_array($actionNotice) && empty($actionNotice))) {
            unset($this->actionNotice);
        } else {
            $this->actionNotice = $actionNotice;
        }
        return $this;
    }
    /**
     * Get location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSGeoPoint|null
     */
    public function getLocation()
    {
        return isset($this->location) ? $this->location : null;
    }
    /**
     * Set location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSGeoPoint $location
     * @return \StructType\WSTaskAction
     */
    public function setLocation(\StructType\WSGeoPoint $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->location);
        } else {
            $this->location = $location;
        }
        return $this;
    }
    /**
     * Get nextStepIndex value
     * @return int|null
     */
    public function getNextStepIndex()
    {
        return $this->nextStepIndex;
    }
    /**
     * Set nextStepIndex value
     * @param int $nextStepIndex
     * @return \StructType\WSTaskAction
     */
    public function setNextStepIndex($nextStepIndex = null)
    {
        // validation for constraint: int
        if (!is_null($nextStepIndex) && !(is_int($nextStepIndex) || ctype_digit($nextStepIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextStepIndex, true), gettype($nextStepIndex)), __LINE__);
        }
        $this->nextStepIndex = $nextStepIndex;
        return $this;
    }
    /**
     * Get nextStepInputs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSTaskInput|null
     */
    public function getNextStepInputs()
    {
        return isset($this->nextStepInputs) ? $this->nextStepInputs : null;
    }
    /**
     * Set nextStepInputs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSTaskInput $nextStepInputs
     * @return \StructType\WSTaskAction
     */
    public function setNextStepInputs(\ArrayType\ArrayOfWSTaskInput $nextStepInputs = null)
    {
        if (is_null($nextStepInputs) || (is_array($nextStepInputs) && empty($nextStepInputs))) {
            unset($this->nextStepInputs);
        } else {
            $this->nextStepInputs = $nextStepInputs;
        }
        return $this;
    }
    /**
     * Get nextStepTarget value
     * @return int|null
     */
    public function getNextStepTarget()
    {
        return $this->nextStepTarget;
    }
    /**
     * Set nextStepTarget value
     * @param int $nextStepTarget
     * @return \StructType\WSTaskAction
     */
    public function setNextStepTarget($nextStepTarget = null)
    {
        // validation for constraint: int
        if (!is_null($nextStepTarget) && !(is_int($nextStepTarget) || ctype_digit($nextStepTarget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextStepTarget, true), gettype($nextStepTarget)), __LINE__);
        }
        $this->nextStepTarget = $nextStepTarget;
        return $this;
    }
    /**
     * Get personId value
     * @return int|null
     */
    public function getPersonId()
    {
        return $this->personId;
    }
    /**
     * Set personId value
     * @param int $personId
     * @return \StructType\WSTaskAction
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: int
        if (!is_null($personId) && !(is_int($personId) || ctype_digit($personId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personId, true), gettype($personId)), __LINE__);
        }
        $this->personId = $personId;
        return $this;
    }
    /**
     * Get stepInputs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSTaskInput|null
     */
    public function getStepInputs()
    {
        return isset($this->stepInputs) ? $this->stepInputs : null;
    }
    /**
     * Set stepInputs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSTaskInput $stepInputs
     * @return \StructType\WSTaskAction
     */
    public function setStepInputs(\ArrayType\ArrayOfWSTaskInput $stepInputs = null)
    {
        if (is_null($stepInputs) || (is_array($stepInputs) && empty($stepInputs))) {
            unset($this->stepInputs);
        } else {
            $this->stepInputs = $stepInputs;
        }
        return $this;
    }
    /**
     * Get taskId value
     * @return int|null
     */
    public function getTaskId()
    {
        return $this->taskId;
    }
    /**
     * Set taskId value
     * @param int $taskId
     * @return \StructType\WSTaskAction
     */
    public function setTaskId($taskId = null)
    {
        // validation for constraint: int
        if (!is_null($taskId) && !(is_int($taskId) || ctype_digit($taskId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taskId, true), gettype($taskId)), __LINE__);
        }
        $this->taskId = $taskId;
        return $this;
    }
    /**
     * Get timestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTimestamp()
    {
        return isset($this->timestamp) ? $this->timestamp : null;
    }
    /**
     * Set timestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $timestamp
     * @return \StructType\WSTaskAction
     */
    public function setTimestamp(\StructType\WSTimestamp $timestamp = null)
    {
        if (is_null($timestamp) || (is_array($timestamp) && empty($timestamp))) {
            unset($this->timestamp);
        } else {
            $this->timestamp = $timestamp;
        }
        return $this;
    }
}
