<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSPerson ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSPerson extends AbstractStructArrayBase
{
    /**
     * The WSPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPerson[]
     */
    public $WSPerson;
    /**
     * Constructor method for ArrayOfWSPerson
     * @uses ArrayOfWSPerson::setWSPerson()
     * @param \StructType\WSPerson[] $wSPerson
     */
    public function __construct(array $wSPerson = array())
    {
        $this
            ->setWSPerson($wSPerson);
    }
    /**
     * Get WSPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPerson[]|null
     */
    public function getWSPerson()
    {
        return isset($this->WSPerson) ? $this->WSPerson : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSPersonForArrayConstraintsFromSetWSPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSPersonWSPersonItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSPersonWSPersonItem instanceof \StructType\WSPerson) {
                $invalidValues[] = is_object($arrayOfWSPersonWSPersonItem) ? get_class($arrayOfWSPersonWSPersonItem) : sprintf('%s(%s)', gettype($arrayOfWSPersonWSPersonItem), var_export($arrayOfWSPersonWSPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSPerson property can only contain items of type \StructType\WSPerson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSPerson[] $wSPerson
     * @return \ArrayType\ArrayOfWSPerson
     */
    public function setWSPerson(array $wSPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($wSPersonArrayErrorMessage = self::validateWSPersonForArrayConstraintsFromSetWSPerson($wSPerson))) {
            throw new \InvalidArgumentException($wSPersonArrayErrorMessage, __LINE__);
        }
        if (is_null($wSPerson) || (is_array($wSPerson) && empty($wSPerson))) {
            unset($this->WSPerson);
        } else {
            $this->WSPerson = $wSPerson;
        }
        return $this;
    }
    /**
     * Add item to WSPerson value
     * @throws \InvalidArgumentException
     * @param \StructType\WSPerson $item
     * @return \ArrayType\ArrayOfWSPerson
     */
    public function addToWSPerson(\StructType\WSPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSPerson) {
            throw new \InvalidArgumentException(sprintf('The WSPerson property can only contain items of type \StructType\WSPerson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSPerson[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSPerson|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSPerson|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSPerson|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSPerson|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSPerson|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSPerson
     */
    public function getAttributeName()
    {
        return 'WSPerson';
    }
}
