<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSKeyValueGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSKeyValueGroup extends AbstractStructArrayBase
{
    /**
     * The WSKeyValueGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSKeyValueGroup[]
     */
    public $WSKeyValueGroup;
    /**
     * Constructor method for ArrayOfWSKeyValueGroup
     * @uses ArrayOfWSKeyValueGroup::setWSKeyValueGroup()
     * @param \StructType\WSKeyValueGroup[] $wSKeyValueGroup
     */
    public function __construct(array $wSKeyValueGroup = array())
    {
        $this
            ->setWSKeyValueGroup($wSKeyValueGroup);
    }
    /**
     * Get WSKeyValueGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSKeyValueGroup[]|null
     */
    public function getWSKeyValueGroup()
    {
        return isset($this->WSKeyValueGroup) ? $this->WSKeyValueGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSKeyValueGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSKeyValueGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSKeyValueGroupForArrayConstraintsFromSetWSKeyValueGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSKeyValueGroupWSKeyValueGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSKeyValueGroupWSKeyValueGroupItem instanceof \StructType\WSKeyValueGroup) {
                $invalidValues[] = is_object($arrayOfWSKeyValueGroupWSKeyValueGroupItem) ? get_class($arrayOfWSKeyValueGroupWSKeyValueGroupItem) : sprintf('%s(%s)', gettype($arrayOfWSKeyValueGroupWSKeyValueGroupItem), var_export($arrayOfWSKeyValueGroupWSKeyValueGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSKeyValueGroup property can only contain items of type \StructType\WSKeyValueGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSKeyValueGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSKeyValueGroup[] $wSKeyValueGroup
     * @return \ArrayType\ArrayOfWSKeyValueGroup
     */
    public function setWSKeyValueGroup(array $wSKeyValueGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($wSKeyValueGroupArrayErrorMessage = self::validateWSKeyValueGroupForArrayConstraintsFromSetWSKeyValueGroup($wSKeyValueGroup))) {
            throw new \InvalidArgumentException($wSKeyValueGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($wSKeyValueGroup) || (is_array($wSKeyValueGroup) && empty($wSKeyValueGroup))) {
            unset($this->WSKeyValueGroup);
        } else {
            $this->WSKeyValueGroup = $wSKeyValueGroup;
        }
        return $this;
    }
    /**
     * Add item to WSKeyValueGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\WSKeyValueGroup $item
     * @return \ArrayType\ArrayOfWSKeyValueGroup
     */
    public function addToWSKeyValueGroup(\StructType\WSKeyValueGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSKeyValueGroup) {
            throw new \InvalidArgumentException(sprintf('The WSKeyValueGroup property can only contain items of type \StructType\WSKeyValueGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSKeyValueGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSKeyValueGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSKeyValueGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSKeyValueGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSKeyValueGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSKeyValueGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSKeyValueGroup
     */
    public function getAttributeName()
    {
        return 'WSKeyValueGroup';
    }
}
