<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSBulkAccountCorrection StructType
 * @subpackage Structs
 */
class WSBulkAccountCorrection extends AbstractStructBase
{
    /**
     * The accountDefinitionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $accountDefinitionID;
    /**
     * The dailyValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSTimestampedValue
     */
    public $dailyValues;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $flags;
    /**
     * Constructor method for WSBulkAccountCorrection
     * @uses WSBulkAccountCorrection::setAccountDefinitionID()
     * @uses WSBulkAccountCorrection::setDailyValues()
     * @uses WSBulkAccountCorrection::setFlags()
     * @param int $accountDefinitionID
     * @param \ArrayType\ArrayOfWSTimestampedValue $dailyValues
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     */
    public function __construct($accountDefinitionID = null, \ArrayType\ArrayOfWSTimestampedValue $dailyValues = null, \ArrayType\ArrayOfWSKeyValue $flags = null)
    {
        $this
            ->setAccountDefinitionID($accountDefinitionID)
            ->setDailyValues($dailyValues)
            ->setFlags($flags);
    }
    /**
     * Get accountDefinitionID value
     * @return int|null
     */
    public function getAccountDefinitionID()
    {
        return $this->accountDefinitionID;
    }
    /**
     * Set accountDefinitionID value
     * @param int $accountDefinitionID
     * @return \StructType\WSBulkAccountCorrection
     */
    public function setAccountDefinitionID($accountDefinitionID = null)
    {
        // validation for constraint: int
        if (!is_null($accountDefinitionID) && !(is_int($accountDefinitionID) || ctype_digit($accountDefinitionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountDefinitionID, true), gettype($accountDefinitionID)), __LINE__);
        }
        $this->accountDefinitionID = $accountDefinitionID;
        return $this;
    }
    /**
     * Get dailyValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSTimestampedValue|null
     */
    public function getDailyValues()
    {
        return isset($this->dailyValues) ? $this->dailyValues : null;
    }
    /**
     * Set dailyValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSTimestampedValue $dailyValues
     * @return \StructType\WSBulkAccountCorrection
     */
    public function setDailyValues(\ArrayType\ArrayOfWSTimestampedValue $dailyValues = null)
    {
        if (is_null($dailyValues) || (is_array($dailyValues) && empty($dailyValues))) {
            unset($this->dailyValues);
        } else {
            $this->dailyValues = $dailyValues;
        }
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @return \StructType\WSBulkAccountCorrection
     */
    public function setFlags(\ArrayType\ArrayOfWSKeyValue $flags = null)
    {
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
}
