<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTrip StructType
 * @subpackage Structs
 */
class WSTrip extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The distance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $distance;
    /**
     * The driver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPerson
     */
    public $driver;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $reason;
    /**
     * The start
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPosition
     */
    public $start;
    /**
     * The stop
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPosition
     */
    public $stop;
    /**
     * The vehicle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSVehicle
     */
    public $vehicle;
    /**
     * Constructor method for WSTrip
     * @uses WSTrip::setID()
     * @uses WSTrip::setDistance()
     * @uses WSTrip::setDriver()
     * @uses WSTrip::setReason()
     * @uses WSTrip::setStart()
     * @uses WSTrip::setStop()
     * @uses WSTrip::setVehicle()
     * @param int $iD
     * @param int $distance
     * @param \StructType\WSPerson $driver
     * @param string $reason
     * @param \StructType\WSPosition $start
     * @param \StructType\WSPosition $stop
     * @param \StructType\WSVehicle $vehicle
     */
    public function __construct($iD = null, $distance = null, \StructType\WSPerson $driver = null, $reason = null, \StructType\WSPosition $start = null, \StructType\WSPosition $stop = null, \StructType\WSVehicle $vehicle = null)
    {
        $this
            ->setID($iD)
            ->setDistance($distance)
            ->setDriver($driver)
            ->setReason($reason)
            ->setStart($start)
            ->setStop($stop)
            ->setVehicle($vehicle);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WSTrip
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set distance value
     * @param int $distance
     * @return \StructType\WSTrip
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->distance = $distance;
        return $this;
    }
    /**
     * Get driver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPerson|null
     */
    public function getDriver()
    {
        return isset($this->driver) ? $this->driver : null;
    }
    /**
     * Set driver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSPerson $driver
     * @return \StructType\WSTrip
     */
    public function setDriver(\StructType\WSPerson $driver = null)
    {
        if (is_null($driver) || (is_array($driver) && empty($driver))) {
            unset($this->driver);
        } else {
            $this->driver = $driver;
        }
        return $this;
    }
    /**
     * Get reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReason()
    {
        return isset($this->reason) ? $this->reason : null;
    }
    /**
     * Set reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reason
     * @return \StructType\WSTrip
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->reason);
        } else {
            $this->reason = $reason;
        }
        return $this;
    }
    /**
     * Get start value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPosition|null
     */
    public function getStart()
    {
        return isset($this->start) ? $this->start : null;
    }
    /**
     * Set start value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSPosition $start
     * @return \StructType\WSTrip
     */
    public function setStart(\StructType\WSPosition $start = null)
    {
        if (is_null($start) || (is_array($start) && empty($start))) {
            unset($this->start);
        } else {
            $this->start = $start;
        }
        return $this;
    }
    /**
     * Get stop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPosition|null
     */
    public function getStop()
    {
        return isset($this->stop) ? $this->stop : null;
    }
    /**
     * Set stop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSPosition $stop
     * @return \StructType\WSTrip
     */
    public function setStop(\StructType\WSPosition $stop = null)
    {
        if (is_null($stop) || (is_array($stop) && empty($stop))) {
            unset($this->stop);
        } else {
            $this->stop = $stop;
        }
        return $this;
    }
    /**
     * Get vehicle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSVehicle|null
     */
    public function getVehicle()
    {
        return isset($this->vehicle) ? $this->vehicle : null;
    }
    /**
     * Set vehicle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSVehicle $vehicle
     * @return \StructType\WSTrip
     */
    public function setVehicle(\StructType\WSVehicle $vehicle = null)
    {
        if (is_null($vehicle) || (is_array($vehicle) && empty($vehicle))) {
            unset($this->vehicle);
        } else {
            $this->vehicle = $vehicle;
        }
        return $this;
    }
}
