<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSForm StructType
 * @subpackage Structs
 */
class WSForm extends AbstractStructBase
{
    /**
     * The action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $action;
    /**
     * The creatorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $creatorId;
    /**
     * The entryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $entryId;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSExtension
     */
    public $extensions;
    /**
     * The formDefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $formDefinitionId;
    /**
     * The formDefinitionVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $formDefinitionVersion;
    /**
     * The fromTs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $fromTs;
    /**
     * The genericProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSGenericProperty
     */
    public $genericProperties;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The keywords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $keywords;
    /**
     * The masterId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $masterId;
    /**
     * The masterType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $masterType;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $state;
    /**
     * The toTs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $toTs;
    /**
     * The tsChanged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $tsChanged;
    /**
     * The tsCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $tsCreated;
    /**
     * Constructor method for WSForm
     * @uses WSForm::setAction()
     * @uses WSForm::setCreatorId()
     * @uses WSForm::setEntryId()
     * @uses WSForm::setExtensions()
     * @uses WSForm::setFormDefinitionId()
     * @uses WSForm::setFormDefinitionVersion()
     * @uses WSForm::setFromTs()
     * @uses WSForm::setGenericProperties()
     * @uses WSForm::setId()
     * @uses WSForm::setKeywords()
     * @uses WSForm::setMasterId()
     * @uses WSForm::setMasterType()
     * @uses WSForm::setState()
     * @uses WSForm::setToTs()
     * @uses WSForm::setTsChanged()
     * @uses WSForm::setTsCreated()
     * @param int $action
     * @param int $creatorId
     * @param string $entryId
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @param int $formDefinitionId
     * @param int $formDefinitionVersion
     * @param \StructType\WSTimestamp $fromTs
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     * @param int $id
     * @param string $keywords
     * @param int $masterId
     * @param int $masterType
     * @param string $state
     * @param \StructType\WSTimestamp $toTs
     * @param \StructType\WSTimestamp $tsChanged
     * @param \StructType\WSTimestamp $tsCreated
     */
    public function __construct($action = null, $creatorId = null, $entryId = null, \ArrayType\ArrayOfWSExtension $extensions = null, $formDefinitionId = null, $formDefinitionVersion = null, \StructType\WSTimestamp $fromTs = null, \ArrayType\ArrayOfWSGenericProperty $genericProperties = null, $id = null, $keywords = null, $masterId = null, $masterType = null, $state = null, \StructType\WSTimestamp $toTs = null, \StructType\WSTimestamp $tsChanged = null, \StructType\WSTimestamp $tsCreated = null)
    {
        $this
            ->setAction($action)
            ->setCreatorId($creatorId)
            ->setEntryId($entryId)
            ->setExtensions($extensions)
            ->setFormDefinitionId($formDefinitionId)
            ->setFormDefinitionVersion($formDefinitionVersion)
            ->setFromTs($fromTs)
            ->setGenericProperties($genericProperties)
            ->setId($id)
            ->setKeywords($keywords)
            ->setMasterId($masterId)
            ->setMasterType($masterType)
            ->setState($state)
            ->setToTs($toTs)
            ->setTsChanged($tsChanged)
            ->setTsCreated($tsCreated);
    }
    /**
     * Get action value
     * @return int|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param int $action
     * @return \StructType\WSForm
     */
    public function setAction($action = null)
    {
        // validation for constraint: int
        if (!is_null($action) && !(is_int($action) || ctype_digit($action))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get creatorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreatorId()
    {
        return isset($this->creatorId) ? $this->creatorId : null;
    }
    /**
     * Set creatorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creatorId
     * @return \StructType\WSForm
     */
    public function setCreatorId($creatorId = null)
    {
        // validation for constraint: int
        if (!is_null($creatorId) && !(is_int($creatorId) || ctype_digit($creatorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creatorId, true), gettype($creatorId)), __LINE__);
        }
        if (is_null($creatorId) || (is_array($creatorId) && empty($creatorId))) {
            unset($this->creatorId);
        } else {
            $this->creatorId = $creatorId;
        }
        return $this;
    }
    /**
     * Get entryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntryId()
    {
        return isset($this->entryId) ? $this->entryId : null;
    }
    /**
     * Set entryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entryId
     * @return \StructType\WSForm
     */
    public function setEntryId($entryId = null)
    {
        // validation for constraint: string
        if (!is_null($entryId) && !is_string($entryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryId, true), gettype($entryId)), __LINE__);
        }
        if (is_null($entryId) || (is_array($entryId) && empty($entryId))) {
            unset($this->entryId);
        } else {
            $this->entryId = $entryId;
        }
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSExtension|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @return \StructType\WSForm
     */
    public function setExtensions(\ArrayType\ArrayOfWSExtension $extensions = null)
    {
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Get formDefinitionId value
     * @return int|null
     */
    public function getFormDefinitionId()
    {
        return $this->formDefinitionId;
    }
    /**
     * Set formDefinitionId value
     * @param int $formDefinitionId
     * @return \StructType\WSForm
     */
    public function setFormDefinitionId($formDefinitionId = null)
    {
        // validation for constraint: int
        if (!is_null($formDefinitionId) && !(is_int($formDefinitionId) || ctype_digit($formDefinitionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formDefinitionId, true), gettype($formDefinitionId)), __LINE__);
        }
        $this->formDefinitionId = $formDefinitionId;
        return $this;
    }
    /**
     * Get formDefinitionVersion value
     * @return int|null
     */
    public function getFormDefinitionVersion()
    {
        return $this->formDefinitionVersion;
    }
    /**
     * Set formDefinitionVersion value
     * @param int $formDefinitionVersion
     * @return \StructType\WSForm
     */
    public function setFormDefinitionVersion($formDefinitionVersion = null)
    {
        // validation for constraint: int
        if (!is_null($formDefinitionVersion) && !(is_int($formDefinitionVersion) || ctype_digit($formDefinitionVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formDefinitionVersion, true), gettype($formDefinitionVersion)), __LINE__);
        }
        $this->formDefinitionVersion = $formDefinitionVersion;
        return $this;
    }
    /**
     * Get fromTs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getFromTs()
    {
        return isset($this->fromTs) ? $this->fromTs : null;
    }
    /**
     * Set fromTs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $fromTs
     * @return \StructType\WSForm
     */
    public function setFromTs(\StructType\WSTimestamp $fromTs = null)
    {
        if (is_null($fromTs) || (is_array($fromTs) && empty($fromTs))) {
            unset($this->fromTs);
        } else {
            $this->fromTs = $fromTs;
        }
        return $this;
    }
    /**
     * Get genericProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSGenericProperty|null
     */
    public function getGenericProperties()
    {
        return isset($this->genericProperties) ? $this->genericProperties : null;
    }
    /**
     * Set genericProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSGenericProperty $genericProperties
     * @return \StructType\WSForm
     */
    public function setGenericProperties(\ArrayType\ArrayOfWSGenericProperty $genericProperties = null)
    {
        if (is_null($genericProperties) || (is_array($genericProperties) && empty($genericProperties))) {
            unset($this->genericProperties);
        } else {
            $this->genericProperties = $genericProperties;
        }
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSForm
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get keywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeywords()
    {
        return isset($this->keywords) ? $this->keywords : null;
    }
    /**
     * Set keywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keywords
     * @return \StructType\WSForm
     */
    public function setKeywords($keywords = null)
    {
        // validation for constraint: string
        if (!is_null($keywords) && !is_string($keywords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keywords, true), gettype($keywords)), __LINE__);
        }
        if (is_null($keywords) || (is_array($keywords) && empty($keywords))) {
            unset($this->keywords);
        } else {
            $this->keywords = $keywords;
        }
        return $this;
    }
    /**
     * Get masterId value
     * @return int|null
     */
    public function getMasterId()
    {
        return $this->masterId;
    }
    /**
     * Set masterId value
     * @param int $masterId
     * @return \StructType\WSForm
     */
    public function setMasterId($masterId = null)
    {
        // validation for constraint: int
        if (!is_null($masterId) && !(is_int($masterId) || ctype_digit($masterId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masterId, true), gettype($masterId)), __LINE__);
        }
        $this->masterId = $masterId;
        return $this;
    }
    /**
     * Get masterType value
     * @return int|null
     */
    public function getMasterType()
    {
        return $this->masterType;
    }
    /**
     * Set masterType value
     * @param int $masterType
     * @return \StructType\WSForm
     */
    public function setMasterType($masterType = null)
    {
        // validation for constraint: int
        if (!is_null($masterType) && !(is_int($masterType) || ctype_digit($masterType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masterType, true), gettype($masterType)), __LINE__);
        }
        $this->masterType = $masterType;
        return $this;
    }
    /**
     * Get state value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : null;
    }
    /**
     * Set state value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\WSForm
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->state);
        } else {
            $this->state = $state;
        }
        return $this;
    }
    /**
     * Get toTs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getToTs()
    {
        return isset($this->toTs) ? $this->toTs : null;
    }
    /**
     * Set toTs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $toTs
     * @return \StructType\WSForm
     */
    public function setToTs(\StructType\WSTimestamp $toTs = null)
    {
        if (is_null($toTs) || (is_array($toTs) && empty($toTs))) {
            unset($this->toTs);
        } else {
            $this->toTs = $toTs;
        }
        return $this;
    }
    /**
     * Get tsChanged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTsChanged()
    {
        return isset($this->tsChanged) ? $this->tsChanged : null;
    }
    /**
     * Set tsChanged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $tsChanged
     * @return \StructType\WSForm
     */
    public function setTsChanged(\StructType\WSTimestamp $tsChanged = null)
    {
        if (is_null($tsChanged) || (is_array($tsChanged) && empty($tsChanged))) {
            unset($this->tsChanged);
        } else {
            $this->tsChanged = $tsChanged;
        }
        return $this;
    }
    /**
     * Get tsCreated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTsCreated()
    {
        return isset($this->tsCreated) ? $this->tsCreated : null;
    }
    /**
     * Set tsCreated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $tsCreated
     * @return \StructType\WSForm
     */
    public function setTsCreated(\StructType\WSTimestamp $tsCreated = null)
    {
        if (is_null($tsCreated) || (is_array($tsCreated) && empty($tsCreated))) {
            unset($this->tsCreated);
        } else {
            $this->tsCreated = $tsCreated;
        }
        return $this;
    }
}
