<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSTask ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSTask extends AbstractStructArrayBase
{
    /**
     * The WSTask
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTask[]
     */
    public $WSTask;
    /**
     * Constructor method for ArrayOfWSTask
     * @uses ArrayOfWSTask::setWSTask()
     * @param \StructType\WSTask[] $wSTask
     */
    public function __construct(array $wSTask = array())
    {
        $this
            ->setWSTask($wSTask);
    }
    /**
     * Get WSTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTask[]|null
     */
    public function getWSTask()
    {
        return isset($this->WSTask) ? $this->WSTask : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSTask method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSTask method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSTaskForArrayConstraintsFromSetWSTask(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSTaskWSTaskItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSTaskWSTaskItem instanceof \StructType\WSTask) {
                $invalidValues[] = is_object($arrayOfWSTaskWSTaskItem) ? get_class($arrayOfWSTaskWSTaskItem) : sprintf('%s(%s)', gettype($arrayOfWSTaskWSTaskItem), var_export($arrayOfWSTaskWSTaskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSTask property can only contain items of type \StructType\WSTask, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSTask[] $wSTask
     * @return \ArrayType\ArrayOfWSTask
     */
    public function setWSTask(array $wSTask = array())
    {
        // validation for constraint: array
        if ('' !== ($wSTaskArrayErrorMessage = self::validateWSTaskForArrayConstraintsFromSetWSTask($wSTask))) {
            throw new \InvalidArgumentException($wSTaskArrayErrorMessage, __LINE__);
        }
        if (is_null($wSTask) || (is_array($wSTask) && empty($wSTask))) {
            unset($this->WSTask);
        } else {
            $this->WSTask = $wSTask;
        }
        return $this;
    }
    /**
     * Add item to WSTask value
     * @throws \InvalidArgumentException
     * @param \StructType\WSTask $item
     * @return \ArrayType\ArrayOfWSTask
     */
    public function addToWSTask(\StructType\WSTask $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSTask) {
            throw new \InvalidArgumentException(sprintf('The WSTask property can only contain items of type \StructType\WSTask, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSTask[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSTask|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSTask|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSTask|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSTask|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSTask|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSTask
     */
    public function getAttributeName()
    {
        return 'WSTask';
    }
}
