<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTerminalModification StructType
 * @subpackage Structs
 */
class WSTerminalModification extends AbstractStructBase
{
    /**
     * The modifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSModification
     */
    public $modifications;
    /**
     * The terminalDBId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $terminalDBId;
    /**
     * The terminalNr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $terminalNr;
    /**
     * The terminalType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $terminalType;
    /**
     * Constructor method for WSTerminalModification
     * @uses WSTerminalModification::setModifications()
     * @uses WSTerminalModification::setTerminalDBId()
     * @uses WSTerminalModification::setTerminalNr()
     * @uses WSTerminalModification::setTerminalType()
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @param int $terminalDBId
     * @param int $terminalNr
     * @param int $terminalType
     */
    public function __construct(\ArrayType\ArrayOfWSModification $modifications = null, $terminalDBId = null, $terminalNr = null, $terminalType = null)
    {
        $this
            ->setModifications($modifications)
            ->setTerminalDBId($terminalDBId)
            ->setTerminalNr($terminalNr)
            ->setTerminalType($terminalType);
    }
    /**
     * Get modifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSModification|null
     */
    public function getModifications()
    {
        return isset($this->modifications) ? $this->modifications : null;
    }
    /**
     * Set modifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @return \StructType\WSTerminalModification
     */
    public function setModifications(\ArrayType\ArrayOfWSModification $modifications = null)
    {
        if (is_null($modifications) || (is_array($modifications) && empty($modifications))) {
            unset($this->modifications);
        } else {
            $this->modifications = $modifications;
        }
        return $this;
    }
    /**
     * Get terminalDBId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTerminalDBId()
    {
        return isset($this->terminalDBId) ? $this->terminalDBId : null;
    }
    /**
     * Set terminalDBId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $terminalDBId
     * @return \StructType\WSTerminalModification
     */
    public function setTerminalDBId($terminalDBId = null)
    {
        // validation for constraint: int
        if (!is_null($terminalDBId) && !(is_int($terminalDBId) || ctype_digit($terminalDBId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalDBId, true), gettype($terminalDBId)), __LINE__);
        }
        if (is_null($terminalDBId) || (is_array($terminalDBId) && empty($terminalDBId))) {
            unset($this->terminalDBId);
        } else {
            $this->terminalDBId = $terminalDBId;
        }
        return $this;
    }
    /**
     * Get terminalNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTerminalNr()
    {
        return isset($this->terminalNr) ? $this->terminalNr : null;
    }
    /**
     * Set terminalNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $terminalNr
     * @return \StructType\WSTerminalModification
     */
    public function setTerminalNr($terminalNr = null)
    {
        // validation for constraint: int
        if (!is_null($terminalNr) && !(is_int($terminalNr) || ctype_digit($terminalNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalNr, true), gettype($terminalNr)), __LINE__);
        }
        if (is_null($terminalNr) || (is_array($terminalNr) && empty($terminalNr))) {
            unset($this->terminalNr);
        } else {
            $this->terminalNr = $terminalNr;
        }
        return $this;
    }
    /**
     * Get terminalType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTerminalType()
    {
        return isset($this->terminalType) ? $this->terminalType : null;
    }
    /**
     * Set terminalType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $terminalType
     * @return \StructType\WSTerminalModification
     */
    public function setTerminalType($terminalType = null)
    {
        // validation for constraint: int
        if (!is_null($terminalType) && !(is_int($terminalType) || ctype_digit($terminalType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalType, true), gettype($terminalType)), __LINE__);
        }
        if (is_null($terminalType) || (is_array($terminalType) && empty($terminalType))) {
            unset($this->terminalType);
        } else {
            $this->terminalType = $terminalType;
        }
        return $this;
    }
}
