<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Open ServiceType
 * @subpackage Services
 */
class Open extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named openSession1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OpenSession1 $parameters
     * @return \StructType\OpenSession1Response|bool
     */
    public function openSession1(\StructType\OpenSession1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->openSession1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named openSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OpenSession $parameters
     * @return \StructType\OpenSessionResponse|bool
     */
    public function openSession(\StructType\OpenSession $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->openSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OpenSession1Response|\StructType\OpenSessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
