<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSTripList ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSTripList extends AbstractStructArrayBase
{
    /**
     * The WSTripList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTripList[]
     */
    public $WSTripList;
    /**
     * Constructor method for ArrayOfWSTripList
     * @uses ArrayOfWSTripList::setWSTripList()
     * @param \StructType\WSTripList[] $wSTripList
     */
    public function __construct(array $wSTripList = array())
    {
        $this
            ->setWSTripList($wSTripList);
    }
    /**
     * Get WSTripList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTripList[]|null
     */
    public function getWSTripList()
    {
        return isset($this->WSTripList) ? $this->WSTripList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSTripList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSTripList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSTripListForArrayConstraintsFromSetWSTripList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSTripListWSTripListItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSTripListWSTripListItem instanceof \StructType\WSTripList) {
                $invalidValues[] = is_object($arrayOfWSTripListWSTripListItem) ? get_class($arrayOfWSTripListWSTripListItem) : sprintf('%s(%s)', gettype($arrayOfWSTripListWSTripListItem), var_export($arrayOfWSTripListWSTripListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSTripList property can only contain items of type \StructType\WSTripList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSTripList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSTripList[] $wSTripList
     * @return \ArrayType\ArrayOfWSTripList
     */
    public function setWSTripList(array $wSTripList = array())
    {
        // validation for constraint: array
        if ('' !== ($wSTripListArrayErrorMessage = self::validateWSTripListForArrayConstraintsFromSetWSTripList($wSTripList))) {
            throw new \InvalidArgumentException($wSTripListArrayErrorMessage, __LINE__);
        }
        if (is_null($wSTripList) || (is_array($wSTripList) && empty($wSTripList))) {
            unset($this->WSTripList);
        } else {
            $this->WSTripList = $wSTripList;
        }
        return $this;
    }
    /**
     * Add item to WSTripList value
     * @throws \InvalidArgumentException
     * @param \StructType\WSTripList $item
     * @return \ArrayType\ArrayOfWSTripList
     */
    public function addToWSTripList(\StructType\WSTripList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSTripList) {
            throw new \InvalidArgumentException(sprintf('The WSTripList property can only contain items of type \StructType\WSTripList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSTripList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSTripList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSTripList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSTripList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSTripList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSTripList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSTripList
     */
    public function getAttributeName()
    {
        return 'WSTripList';
    }
}
