<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSGenericProperty ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSGenericProperty extends AbstractStructArrayBase
{
    /**
     * The WSGenericProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSGenericProperty[]
     */
    public $WSGenericProperty;
    /**
     * Constructor method for ArrayOfWSGenericProperty
     * @uses ArrayOfWSGenericProperty::setWSGenericProperty()
     * @param \StructType\WSGenericProperty[] $wSGenericProperty
     */
    public function __construct(array $wSGenericProperty = array())
    {
        $this
            ->setWSGenericProperty($wSGenericProperty);
    }
    /**
     * Get WSGenericProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSGenericProperty[]|null
     */
    public function getWSGenericProperty()
    {
        return isset($this->WSGenericProperty) ? $this->WSGenericProperty : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSGenericProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSGenericProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSGenericPropertyForArrayConstraintsFromSetWSGenericProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSGenericPropertyWSGenericPropertyItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSGenericPropertyWSGenericPropertyItem instanceof \StructType\WSGenericProperty) {
                $invalidValues[] = is_object($arrayOfWSGenericPropertyWSGenericPropertyItem) ? get_class($arrayOfWSGenericPropertyWSGenericPropertyItem) : sprintf('%s(%s)', gettype($arrayOfWSGenericPropertyWSGenericPropertyItem), var_export($arrayOfWSGenericPropertyWSGenericPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSGenericProperty property can only contain items of type \StructType\WSGenericProperty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSGenericProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSGenericProperty[] $wSGenericProperty
     * @return \ArrayType\ArrayOfWSGenericProperty
     */
    public function setWSGenericProperty(array $wSGenericProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($wSGenericPropertyArrayErrorMessage = self::validateWSGenericPropertyForArrayConstraintsFromSetWSGenericProperty($wSGenericProperty))) {
            throw new \InvalidArgumentException($wSGenericPropertyArrayErrorMessage, __LINE__);
        }
        if (is_null($wSGenericProperty) || (is_array($wSGenericProperty) && empty($wSGenericProperty))) {
            unset($this->WSGenericProperty);
        } else {
            $this->WSGenericProperty = $wSGenericProperty;
        }
        return $this;
    }
    /**
     * Add item to WSGenericProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\WSGenericProperty $item
     * @return \ArrayType\ArrayOfWSGenericProperty
     */
    public function addToWSGenericProperty(\StructType\WSGenericProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSGenericProperty) {
            throw new \InvalidArgumentException(sprintf('The WSGenericProperty property can only contain items of type \StructType\WSGenericProperty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSGenericProperty[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSGenericProperty|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSGenericProperty|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSGenericProperty|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSGenericProperty|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSGenericProperty|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSGenericProperty
     */
    public function getAttributeName()
    {
        return 'WSGenericProperty';
    }
}
