<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSCustomer ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSCustomer extends AbstractStructArrayBase
{
    /**
     * The WSCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSCustomer[]
     */
    public $WSCustomer;
    /**
     * Constructor method for ArrayOfWSCustomer
     * @uses ArrayOfWSCustomer::setWSCustomer()
     * @param \StructType\WSCustomer[] $wSCustomer
     */
    public function __construct(array $wSCustomer = array())
    {
        $this
            ->setWSCustomer($wSCustomer);
    }
    /**
     * Get WSCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSCustomer[]|null
     */
    public function getWSCustomer()
    {
        return isset($this->WSCustomer) ? $this->WSCustomer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSCustomerForArrayConstraintsFromSetWSCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSCustomerWSCustomerItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSCustomerWSCustomerItem instanceof \StructType\WSCustomer) {
                $invalidValues[] = is_object($arrayOfWSCustomerWSCustomerItem) ? get_class($arrayOfWSCustomerWSCustomerItem) : sprintf('%s(%s)', gettype($arrayOfWSCustomerWSCustomerItem), var_export($arrayOfWSCustomerWSCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSCustomer property can only contain items of type \StructType\WSCustomer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomer[] $wSCustomer
     * @return \ArrayType\ArrayOfWSCustomer
     */
    public function setWSCustomer(array $wSCustomer = array())
    {
        // validation for constraint: array
        if ('' !== ($wSCustomerArrayErrorMessage = self::validateWSCustomerForArrayConstraintsFromSetWSCustomer($wSCustomer))) {
            throw new \InvalidArgumentException($wSCustomerArrayErrorMessage, __LINE__);
        }
        if (is_null($wSCustomer) || (is_array($wSCustomer) && empty($wSCustomer))) {
            unset($this->WSCustomer);
        } else {
            $this->WSCustomer = $wSCustomer;
        }
        return $this;
    }
    /**
     * Add item to WSCustomer value
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomer $item
     * @return \ArrayType\ArrayOfWSCustomer
     */
    public function addToWSCustomer(\StructType\WSCustomer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSCustomer) {
            throw new \InvalidArgumentException(sprintf('The WSCustomer property can only contain items of type \StructType\WSCustomer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSCustomer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSCustomer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSCustomer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSCustomer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSCustomer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSCustomer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSCustomer
     */
    public function getAttributeName()
    {
        return 'WSCustomer';
    }
}
