<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSAttachedDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSAttachedDocument extends AbstractStructArrayBase
{
    /**
     * The WSAttachedDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSAttachedDocument[]
     */
    public $WSAttachedDocument;
    /**
     * Constructor method for ArrayOfWSAttachedDocument
     * @uses ArrayOfWSAttachedDocument::setWSAttachedDocument()
     * @param \StructType\WSAttachedDocument[] $wSAttachedDocument
     */
    public function __construct(array $wSAttachedDocument = array())
    {
        $this
            ->setWSAttachedDocument($wSAttachedDocument);
    }
    /**
     * Get WSAttachedDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSAttachedDocument[]|null
     */
    public function getWSAttachedDocument()
    {
        return isset($this->WSAttachedDocument) ? $this->WSAttachedDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSAttachedDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSAttachedDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSAttachedDocumentForArrayConstraintsFromSetWSAttachedDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSAttachedDocumentWSAttachedDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSAttachedDocumentWSAttachedDocumentItem instanceof \StructType\WSAttachedDocument) {
                $invalidValues[] = is_object($arrayOfWSAttachedDocumentWSAttachedDocumentItem) ? get_class($arrayOfWSAttachedDocumentWSAttachedDocumentItem) : sprintf('%s(%s)', gettype($arrayOfWSAttachedDocumentWSAttachedDocumentItem), var_export($arrayOfWSAttachedDocumentWSAttachedDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSAttachedDocument property can only contain items of type \StructType\WSAttachedDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSAttachedDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSAttachedDocument[] $wSAttachedDocument
     * @return \ArrayType\ArrayOfWSAttachedDocument
     */
    public function setWSAttachedDocument(array $wSAttachedDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($wSAttachedDocumentArrayErrorMessage = self::validateWSAttachedDocumentForArrayConstraintsFromSetWSAttachedDocument($wSAttachedDocument))) {
            throw new \InvalidArgumentException($wSAttachedDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($wSAttachedDocument) || (is_array($wSAttachedDocument) && empty($wSAttachedDocument))) {
            unset($this->WSAttachedDocument);
        } else {
            $this->WSAttachedDocument = $wSAttachedDocument;
        }
        return $this;
    }
    /**
     * Add item to WSAttachedDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\WSAttachedDocument $item
     * @return \ArrayType\ArrayOfWSAttachedDocument
     */
    public function addToWSAttachedDocument(\StructType\WSAttachedDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSAttachedDocument) {
            throw new \InvalidArgumentException(sprintf('The WSAttachedDocument property can only contain items of type \StructType\WSAttachedDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSAttachedDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSAttachedDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSAttachedDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSAttachedDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSAttachedDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSAttachedDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSAttachedDocument
     */
    public function getAttributeName()
    {
        return 'WSAttachedDocument';
    }
}
