<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSCalendarEntry StructType
 * @subpackage Structs
 */
class WSCalendarEntry extends AbstractStructBase
{
    /**
     * The calendarId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $calendarId;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $flags;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $timestamp;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $type;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * Constructor method for WSCalendarEntry
     * @uses WSCalendarEntry::setCalendarId()
     * @uses WSCalendarEntry::setFlags()
     * @uses WSCalendarEntry::setId()
     * @uses WSCalendarEntry::setName()
     * @uses WSCalendarEntry::setTimestamp()
     * @uses WSCalendarEntry::setType()
     * @uses WSCalendarEntry::setWeight()
     * @param int $calendarId
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @param int $id
     * @param string $name
     * @param \StructType\WSTimestamp $timestamp
     * @param int $type
     * @param float $weight
     */
    public function __construct($calendarId = null, \ArrayType\ArrayOfWSKeyValue $flags = null, $id = null, $name = null, \StructType\WSTimestamp $timestamp = null, $type = null, $weight = null)
    {
        $this
            ->setCalendarId($calendarId)
            ->setFlags($flags)
            ->setId($id)
            ->setName($name)
            ->setTimestamp($timestamp)
            ->setType($type)
            ->setWeight($weight);
    }
    /**
     * Get calendarId value
     * @return int|null
     */
    public function getCalendarId()
    {
        return $this->calendarId;
    }
    /**
     * Set calendarId value
     * @param int $calendarId
     * @return \StructType\WSCalendarEntry
     */
    public function setCalendarId($calendarId = null)
    {
        // validation for constraint: int
        if (!is_null($calendarId) && !(is_int($calendarId) || ctype_digit($calendarId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($calendarId, true), gettype($calendarId)), __LINE__);
        }
        $this->calendarId = $calendarId;
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $flags
     * @return \StructType\WSCalendarEntry
     */
    public function setFlags(\ArrayType\ArrayOfWSKeyValue $flags = null)
    {
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\WSCalendarEntry
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSCalendarEntry
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get timestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTimestamp()
    {
        return isset($this->timestamp) ? $this->timestamp : null;
    }
    /**
     * Set timestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $timestamp
     * @return \StructType\WSCalendarEntry
     */
    public function setTimestamp(\StructType\WSTimestamp $timestamp = null)
    {
        if (is_null($timestamp) || (is_array($timestamp) && empty($timestamp))) {
            unset($this->timestamp);
        } else {
            $this->timestamp = $timestamp;
        }
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \StructType\WSCalendarEntry
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\WSCalendarEntry
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
}
