<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSExtensibleCustomer StructType
 * @subpackage Structs
 */
class WSExtensibleCustomer extends BasicExtensibleObject
{
    /**
     * The wsCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSCustomer
     */
    public $wsCustomer;
    /**
     * Constructor method for WSExtensibleCustomer
     * @uses WSExtensibleCustomer::setWsCustomer()
     * @param \StructType\WSCustomer $wsCustomer
     */
    public function __construct(\StructType\WSCustomer $wsCustomer = null)
    {
        $this
            ->setWsCustomer($wsCustomer);
    }
    /**
     * Get wsCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSCustomer|null
     */
    public function getWsCustomer()
    {
        return isset($this->wsCustomer) ? $this->wsCustomer : null;
    }
    /**
     * Set wsCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSCustomer $wsCustomer
     * @return \StructType\WSExtensibleCustomer
     */
    public function setWsCustomer(\StructType\WSCustomer $wsCustomer = null)
    {
        if (is_null($wsCustomer) || (is_array($wsCustomer) && empty($wsCustomer))) {
            unset($this->wsCustomer);
        } else {
            $this->wsCustomer = $wsCustomer;
        }
        return $this;
    }
}
