<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSDate ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSDate extends AbstractStructArrayBase
{
    /**
     * The WSDate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSDate[]
     */
    public $WSDate;
    /**
     * Constructor method for ArrayOfWSDate
     * @uses ArrayOfWSDate::setWSDate()
     * @param \StructType\WSDate[] $wSDate
     */
    public function __construct(array $wSDate = array())
    {
        $this
            ->setWSDate($wSDate);
    }
    /**
     * Get WSDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSDate[]|null
     */
    public function getWSDate()
    {
        return isset($this->WSDate) ? $this->WSDate : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSDateForArrayConstraintsFromSetWSDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSDateWSDateItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSDateWSDateItem instanceof \StructType\WSDate) {
                $invalidValues[] = is_object($arrayOfWSDateWSDateItem) ? get_class($arrayOfWSDateWSDateItem) : sprintf('%s(%s)', gettype($arrayOfWSDateWSDateItem), var_export($arrayOfWSDateWSDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSDate property can only contain items of type \StructType\WSDate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSDate[] $wSDate
     * @return \ArrayType\ArrayOfWSDate
     */
    public function setWSDate(array $wSDate = array())
    {
        // validation for constraint: array
        if ('' !== ($wSDateArrayErrorMessage = self::validateWSDateForArrayConstraintsFromSetWSDate($wSDate))) {
            throw new \InvalidArgumentException($wSDateArrayErrorMessage, __LINE__);
        }
        if (is_null($wSDate) || (is_array($wSDate) && empty($wSDate))) {
            unset($this->WSDate);
        } else {
            $this->WSDate = $wSDate;
        }
        return $this;
    }
    /**
     * Add item to WSDate value
     * @throws \InvalidArgumentException
     * @param \StructType\WSDate $item
     * @return \ArrayType\ArrayOfWSDate
     */
    public function addToWSDate(\StructType\WSDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSDate) {
            throw new \InvalidArgumentException(sprintf('The WSDate property can only contain items of type \StructType\WSDate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSDate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSDate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSDate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSDate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSDate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSDate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSDate
     */
    public function getAttributeName()
    {
        return 'WSDate';
    }
}
