<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSProperty ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSProperty extends AbstractStructArrayBase
{
    /**
     * The WSProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSProperty[]
     */
    public $WSProperty;
    /**
     * Constructor method for ArrayOfWSProperty
     * @uses ArrayOfWSProperty::setWSProperty()
     * @param \StructType\WSProperty[] $wSProperty
     */
    public function __construct(array $wSProperty = array())
    {
        $this
            ->setWSProperty($wSProperty);
    }
    /**
     * Get WSProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSProperty[]|null
     */
    public function getWSProperty()
    {
        return isset($this->WSProperty) ? $this->WSProperty : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSPropertyForArrayConstraintsFromSetWSProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSPropertyWSPropertyItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSPropertyWSPropertyItem instanceof \StructType\WSProperty) {
                $invalidValues[] = is_object($arrayOfWSPropertyWSPropertyItem) ? get_class($arrayOfWSPropertyWSPropertyItem) : sprintf('%s(%s)', gettype($arrayOfWSPropertyWSPropertyItem), var_export($arrayOfWSPropertyWSPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSProperty property can only contain items of type \StructType\WSProperty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSProperty[] $wSProperty
     * @return \ArrayType\ArrayOfWSProperty
     */
    public function setWSProperty(array $wSProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($wSPropertyArrayErrorMessage = self::validateWSPropertyForArrayConstraintsFromSetWSProperty($wSProperty))) {
            throw new \InvalidArgumentException($wSPropertyArrayErrorMessage, __LINE__);
        }
        if (is_null($wSProperty) || (is_array($wSProperty) && empty($wSProperty))) {
            unset($this->WSProperty);
        } else {
            $this->WSProperty = $wSProperty;
        }
        return $this;
    }
    /**
     * Add item to WSProperty value
     * @throws \InvalidArgumentException
     * @param \StructType\WSProperty $item
     * @return \ArrayType\ArrayOfWSProperty
     */
    public function addToWSProperty(\StructType\WSProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSProperty) {
            throw new \InvalidArgumentException(sprintf('The WSProperty property can only contain items of type \StructType\WSProperty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSProperty[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSProperty|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSProperty|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSProperty|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSProperty|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSProperty|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSProperty
     */
    public function getAttributeName()
    {
        return 'WSProperty';
    }
}
