<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSKeyValue StructType
 * @subpackage Structs
 */
class WSKeyValue extends AbstractStructBase
{
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $flags;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $key;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * Constructor method for WSKeyValue
     * @uses WSKeyValue::setFlags()
     * @uses WSKeyValue::setKey()
     * @uses WSKeyValue::setValue()
     * @param int $flags
     * @param string $key
     * @param string $value
     */
    public function __construct($flags = null, $key = null, $value = null)
    {
        $this
            ->setFlags($flags)
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get flags value
     * @return int|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param int $flags
     * @return \StructType\WSKeyValue
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: int
        if (!is_null($flags) && !(is_int($flags) || ctype_digit($flags))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flags, true), gettype($flags)), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->key) ? $this->key : null;
    }
    /**
     * Set key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\WSKeyValue
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->key);
        } else {
            $this->key = $key;
        }
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\WSKeyValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
}
