<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSEntryPermission StructType
 * @subpackage Structs
 */
class WSEntryPermission extends AbstractStructBase
{
    /**
     * The cardList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $cardList;
    /**
     * The periodDefinitionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $periodDefinitionId;
    /**
     * Constructor method for WSEntryPermission
     * @uses WSEntryPermission::setCardList()
     * @uses WSEntryPermission::setPeriodDefinitionId()
     * @param \ArrayType\ArrayOfWSKeyValue $cardList
     * @param int $periodDefinitionId
     */
    public function __construct(\ArrayType\ArrayOfWSKeyValue $cardList = null, $periodDefinitionId = null)
    {
        $this
            ->setCardList($cardList)
            ->setPeriodDefinitionId($periodDefinitionId);
    }
    /**
     * Get cardList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getCardList()
    {
        return isset($this->cardList) ? $this->cardList : null;
    }
    /**
     * Set cardList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $cardList
     * @return \StructType\WSEntryPermission
     */
    public function setCardList(\ArrayType\ArrayOfWSKeyValue $cardList = null)
    {
        if (is_null($cardList) || (is_array($cardList) && empty($cardList))) {
            unset($this->cardList);
        } else {
            $this->cardList = $cardList;
        }
        return $this;
    }
    /**
     * Get periodDefinitionId value
     * @return int|null
     */
    public function getPeriodDefinitionId()
    {
        return $this->periodDefinitionId;
    }
    /**
     * Set periodDefinitionId value
     * @param int $periodDefinitionId
     * @return \StructType\WSEntryPermission
     */
    public function setPeriodDefinitionId($periodDefinitionId = null)
    {
        // validation for constraint: int
        if (!is_null($periodDefinitionId) && !(is_int($periodDefinitionId) || ctype_digit($periodDefinitionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($periodDefinitionId, true), gettype($periodDefinitionId)), __LINE__);
        }
        $this->periodDefinitionId = $periodDefinitionId;
        return $this;
    }
}
