<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSDate StructType
 * @subpackage Structs
 */
class WSDate extends AbstractStructBase
{
    /**
     * The TS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TS;
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $additionalInfo;
    /**
     * The day
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $day;
    /**
     * The month
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $month;
    /**
     * The year
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $year;
    /**
     * Constructor method for WSDate
     * @uses WSDate::setTS()
     * @uses WSDate::setAdditionalInfo()
     * @uses WSDate::setDay()
     * @uses WSDate::setMonth()
     * @uses WSDate::setYear()
     * @param int $tS
     * @param \ArrayType\ArrayOfWSKeyValue $additionalInfo
     * @param int $day
     * @param int $month
     * @param int $year
     */
    public function __construct($tS = null, \ArrayType\ArrayOfWSKeyValue $additionalInfo = null, $day = null, $month = null, $year = null)
    {
        $this
            ->setTS($tS)
            ->setAdditionalInfo($additionalInfo)
            ->setDay($day)
            ->setMonth($month)
            ->setYear($year);
    }
    /**
     * Get TS value
     * @return int|null
     */
    public function getTS()
    {
        return $this->TS;
    }
    /**
     * Set TS value
     * @param int $tS
     * @return \StructType\WSDate
     */
    public function setTS($tS = null)
    {
        // validation for constraint: int
        if (!is_null($tS) && !(is_int($tS) || ctype_digit($tS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tS, true), gettype($tS)), __LINE__);
        }
        $this->TS = $tS;
        return $this;
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $additionalInfo
     * @return \StructType\WSDate
     */
    public function setAdditionalInfo(\ArrayType\ArrayOfWSKeyValue $additionalInfo = null)
    {
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Get day value
     * @return int|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param int $day
     * @return \StructType\WSDate
     */
    public function setDay($day = null)
    {
        // validation for constraint: int
        if (!is_null($day) && !(is_int($day) || ctype_digit($day))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($day, true), gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get month value
     * @return int|null
     */
    public function getMonth()
    {
        return $this->month;
    }
    /**
     * Set month value
     * @param int $month
     * @return \StructType\WSDate
     */
    public function setMonth($month = null)
    {
        // validation for constraint: int
        if (!is_null($month) && !(is_int($month) || ctype_digit($month))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($month, true), gettype($month)), __LINE__);
        }
        $this->month = $month;
        return $this;
    }
    /**
     * Get year value
     * @return int|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\WSDate
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
}
