<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Refresh ServiceType
 * @subpackage Services
 */
class Refresh extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named refreshSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RefreshSession $parameters
     * @return \StructType\RefreshSessionResponse|bool
     */
    public function refreshSession(\StructType\RefreshSession $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->refreshSession($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RefreshSessionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
