<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTrip2 StructType
 * @subpackage Structs
 */
class WSTrip2 extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The additionalValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $additionalValues;
    /**
     * The checkLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $checkLevel;
    /**
     * The distance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $distance;
    /**
     * The driver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $driver;
    /**
     * The extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSExtension
     */
    public $extensions;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $flags;
    /**
     * The mode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mode;
    /**
     * The passengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSLink
     */
    public $passengers;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $reason;
    /**
     * The start
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPosition
     */
    public $start;
    /**
     * The stop
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPosition
     */
    public $stop;
    /**
     * The vehicle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $vehicle;
    /**
     * Constructor method for WSTrip2
     * @uses WSTrip2::setID()
     * @uses WSTrip2::setAdditionalValues()
     * @uses WSTrip2::setCheckLevel()
     * @uses WSTrip2::setDistance()
     * @uses WSTrip2::setDriver()
     * @uses WSTrip2::setExtensions()
     * @uses WSTrip2::setFlags()
     * @uses WSTrip2::setMode()
     * @uses WSTrip2::setPassengers()
     * @uses WSTrip2::setReason()
     * @uses WSTrip2::setStart()
     * @uses WSTrip2::setStop()
     * @uses WSTrip2::setVehicle()
     * @param int $iD
     * @param \ArrayType\ArrayOfWSKeyValue $additionalValues
     * @param int $checkLevel
     * @param int $distance
     * @param \StructType\WSLink $driver
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @param int $flags
     * @param string $mode
     * @param \ArrayType\ArrayOfWSLink $passengers
     * @param string $reason
     * @param \StructType\WSPosition $start
     * @param \StructType\WSPosition $stop
     * @param \StructType\WSLink $vehicle
     */
    public function __construct($iD = null, \ArrayType\ArrayOfWSKeyValue $additionalValues = null, $checkLevel = null, $distance = null, \StructType\WSLink $driver = null, \ArrayType\ArrayOfWSExtension $extensions = null, $flags = null, $mode = null, \ArrayType\ArrayOfWSLink $passengers = null, $reason = null, \StructType\WSPosition $start = null, \StructType\WSPosition $stop = null, \StructType\WSLink $vehicle = null)
    {
        $this
            ->setID($iD)
            ->setAdditionalValues($additionalValues)
            ->setCheckLevel($checkLevel)
            ->setDistance($distance)
            ->setDriver($driver)
            ->setExtensions($extensions)
            ->setFlags($flags)
            ->setMode($mode)
            ->setPassengers($passengers)
            ->setReason($reason)
            ->setStart($start)
            ->setStop($stop)
            ->setVehicle($vehicle);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WSTrip2
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get additionalValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getAdditionalValues()
    {
        return isset($this->additionalValues) ? $this->additionalValues : null;
    }
    /**
     * Set additionalValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $additionalValues
     * @return \StructType\WSTrip2
     */
    public function setAdditionalValues(\ArrayType\ArrayOfWSKeyValue $additionalValues = null)
    {
        if (is_null($additionalValues) || (is_array($additionalValues) && empty($additionalValues))) {
            unset($this->additionalValues);
        } else {
            $this->additionalValues = $additionalValues;
        }
        return $this;
    }
    /**
     * Get checkLevel value
     * @return int|null
     */
    public function getCheckLevel()
    {
        return $this->checkLevel;
    }
    /**
     * Set checkLevel value
     * @param int $checkLevel
     * @return \StructType\WSTrip2
     */
    public function setCheckLevel($checkLevel = null)
    {
        // validation for constraint: int
        if (!is_null($checkLevel) && !(is_int($checkLevel) || ctype_digit($checkLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($checkLevel, true), gettype($checkLevel)), __LINE__);
        }
        $this->checkLevel = $checkLevel;
        return $this;
    }
    /**
     * Get distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->distance;
    }
    /**
     * Set distance value
     * @param int $distance
     * @return \StructType\WSTrip2
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->distance = $distance;
        return $this;
    }
    /**
     * Get driver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getDriver()
    {
        return isset($this->driver) ? $this->driver : null;
    }
    /**
     * Set driver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $driver
     * @return \StructType\WSTrip2
     */
    public function setDriver(\StructType\WSLink $driver = null)
    {
        if (is_null($driver) || (is_array($driver) && empty($driver))) {
            unset($this->driver);
        } else {
            $this->driver = $driver;
        }
        return $this;
    }
    /**
     * Get extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSExtension|null
     */
    public function getExtensions()
    {
        return isset($this->extensions) ? $this->extensions : null;
    }
    /**
     * Set extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSExtension $extensions
     * @return \StructType\WSTrip2
     */
    public function setExtensions(\ArrayType\ArrayOfWSExtension $extensions = null)
    {
        if (is_null($extensions) || (is_array($extensions) && empty($extensions))) {
            unset($this->extensions);
        } else {
            $this->extensions = $extensions;
        }
        return $this;
    }
    /**
     * Get flags value
     * @return int|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param int $flags
     * @return \StructType\WSTrip2
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: int
        if (!is_null($flags) && !(is_int($flags) || ctype_digit($flags))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flags, true), gettype($flags)), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->mode) ? $this->mode : null;
    }
    /**
     * Set mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mode
     * @return \StructType\WSTrip2
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mode, true), gettype($mode)), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->mode);
        } else {
            $this->mode = $mode;
        }
        return $this;
    }
    /**
     * Get passengers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSLink|null
     */
    public function getPassengers()
    {
        return isset($this->passengers) ? $this->passengers : null;
    }
    /**
     * Set passengers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSLink $passengers
     * @return \StructType\WSTrip2
     */
    public function setPassengers(\ArrayType\ArrayOfWSLink $passengers = null)
    {
        if (is_null($passengers) || (is_array($passengers) && empty($passengers))) {
            unset($this->passengers);
        } else {
            $this->passengers = $passengers;
        }
        return $this;
    }
    /**
     * Get reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReason()
    {
        return isset($this->reason) ? $this->reason : null;
    }
    /**
     * Set reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reason
     * @return \StructType\WSTrip2
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->reason);
        } else {
            $this->reason = $reason;
        }
        return $this;
    }
    /**
     * Get start value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPosition|null
     */
    public function getStart()
    {
        return isset($this->start) ? $this->start : null;
    }
    /**
     * Set start value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSPosition $start
     * @return \StructType\WSTrip2
     */
    public function setStart(\StructType\WSPosition $start = null)
    {
        if (is_null($start) || (is_array($start) && empty($start))) {
            unset($this->start);
        } else {
            $this->start = $start;
        }
        return $this;
    }
    /**
     * Get stop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPosition|null
     */
    public function getStop()
    {
        return isset($this->stop) ? $this->stop : null;
    }
    /**
     * Set stop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSPosition $stop
     * @return \StructType\WSTrip2
     */
    public function setStop(\StructType\WSPosition $stop = null)
    {
        if (is_null($stop) || (is_array($stop) && empty($stop))) {
            unset($this->stop);
        } else {
            $this->stop = $stop;
        }
        return $this;
    }
    /**
     * Get vehicle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getVehicle()
    {
        return isset($this->vehicle) ? $this->vehicle : null;
    }
    /**
     * Set vehicle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $vehicle
     * @return \StructType\WSTrip2
     */
    public function setVehicle(\StructType\WSLink $vehicle = null)
    {
        if (is_null($vehicle) || (is_array($vehicle) && empty($vehicle))) {
            unset($this->vehicle);
        } else {
            $this->vehicle = $vehicle;
        }
        return $this;
    }
}
