<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTaskInput StructType
 * @subpackage Structs
 */
class WSTaskInput extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $index;
    /**
     * The link
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $link;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * The valueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $valueType;
    /**
     * Constructor method for WSTaskInput
     * @uses WSTaskInput::setIndex()
     * @uses WSTaskInput::setLink()
     * @uses WSTaskInput::setValue()
     * @uses WSTaskInput::setValueType()
     * @param int $index
     * @param \StructType\WSLink $link
     * @param string $value
     * @param string $valueType
     */
    public function __construct($index = null, \StructType\WSLink $link = null, $value = null, $valueType = null)
    {
        $this
            ->setIndex($index)
            ->setLink($link)
            ->setValue($value)
            ->setValueType($valueType);
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \StructType\WSTaskInput
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !(is_int($index) || ctype_digit($index))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($index, true), gettype($index)), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get link value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getLink()
    {
        return isset($this->link) ? $this->link : null;
    }
    /**
     * Set link value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $link
     * @return \StructType\WSTaskInput
     */
    public function setLink(\StructType\WSLink $link = null)
    {
        if (is_null($link) || (is_array($link) && empty($link))) {
            unset($this->link);
        } else {
            $this->link = $link;
        }
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \StructType\WSTaskInput
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
    /**
     * Get valueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueType()
    {
        return isset($this->valueType) ? $this->valueType : null;
    }
    /**
     * Set valueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valueType
     * @return \StructType\WSTaskInput
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueType, true), gettype($valueType)), __LINE__);
        }
        if (is_null($valueType) || (is_array($valueType) && empty($valueType))) {
            unset($this->valueType);
        } else {
            $this->valueType = $valueType;
        }
        return $this;
    }
}
