<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSEntryDoorPermissionBlock StructType
 * @subpackage Structs
 */
class WSEntryDoorPermissionBlock extends AbstractStructBase
{
    /**
     * The calendarId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $calendarId;
    /**
     * The doorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $doorId;
    /**
     * The permissions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSEntryPermission
     */
    public $permissions;
    /**
     * Constructor method for WSEntryDoorPermissionBlock
     * @uses WSEntryDoorPermissionBlock::setCalendarId()
     * @uses WSEntryDoorPermissionBlock::setDoorId()
     * @uses WSEntryDoorPermissionBlock::setPermissions()
     * @param int $calendarId
     * @param int $doorId
     * @param \ArrayType\ArrayOfWSEntryPermission $permissions
     */
    public function __construct($calendarId = null, $doorId = null, \ArrayType\ArrayOfWSEntryPermission $permissions = null)
    {
        $this
            ->setCalendarId($calendarId)
            ->setDoorId($doorId)
            ->setPermissions($permissions);
    }
    /**
     * Get calendarId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCalendarId()
    {
        return isset($this->calendarId) ? $this->calendarId : null;
    }
    /**
     * Set calendarId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $calendarId
     * @return \StructType\WSEntryDoorPermissionBlock
     */
    public function setCalendarId($calendarId = null)
    {
        // validation for constraint: int
        if (!is_null($calendarId) && !(is_int($calendarId) || ctype_digit($calendarId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($calendarId, true), gettype($calendarId)), __LINE__);
        }
        if (is_null($calendarId) || (is_array($calendarId) && empty($calendarId))) {
            unset($this->calendarId);
        } else {
            $this->calendarId = $calendarId;
        }
        return $this;
    }
    /**
     * Get doorId value
     * @return int|null
     */
    public function getDoorId()
    {
        return $this->doorId;
    }
    /**
     * Set doorId value
     * @param int $doorId
     * @return \StructType\WSEntryDoorPermissionBlock
     */
    public function setDoorId($doorId = null)
    {
        // validation for constraint: int
        if (!is_null($doorId) && !(is_int($doorId) || ctype_digit($doorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doorId, true), gettype($doorId)), __LINE__);
        }
        $this->doorId = $doorId;
        return $this;
    }
    /**
     * Get permissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSEntryPermission|null
     */
    public function getPermissions()
    {
        return isset($this->permissions) ? $this->permissions : null;
    }
    /**
     * Set permissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSEntryPermission $permissions
     * @return \StructType\WSEntryDoorPermissionBlock
     */
    public function setPermissions(\ArrayType\ArrayOfWSEntryPermission $permissions = null)
    {
        if (is_null($permissions) || (is_array($permissions) && empty($permissions))) {
            unset($this->permissions);
        } else {
            $this->permissions = $permissions;
        }
        return $this;
    }
}
