<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSLinkWithDates StructType
 * @subpackage Structs
 */
class WSLinkWithDates extends AbstractStructBase
{
    /**
     * The additionalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $additionalInfo;
    /**
     * The dates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSDate
     */
    public $dates;
    /**
     * The link
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $link;
    /**
     * Constructor method for WSLinkWithDates
     * @uses WSLinkWithDates::setAdditionalInfo()
     * @uses WSLinkWithDates::setDates()
     * @uses WSLinkWithDates::setLink()
     * @param \ArrayType\ArrayOfWSKeyValue $additionalInfo
     * @param \ArrayType\ArrayOfWSDate $dates
     * @param \StructType\WSLink $link
     */
    public function __construct(\ArrayType\ArrayOfWSKeyValue $additionalInfo = null, \ArrayType\ArrayOfWSDate $dates = null, \StructType\WSLink $link = null)
    {
        $this
            ->setAdditionalInfo($additionalInfo)
            ->setDates($dates)
            ->setLink($link);
    }
    /**
     * Get additionalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getAdditionalInfo()
    {
        return isset($this->additionalInfo) ? $this->additionalInfo : null;
    }
    /**
     * Set additionalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $additionalInfo
     * @return \StructType\WSLinkWithDates
     */
    public function setAdditionalInfo(\ArrayType\ArrayOfWSKeyValue $additionalInfo = null)
    {
        if (is_null($additionalInfo) || (is_array($additionalInfo) && empty($additionalInfo))) {
            unset($this->additionalInfo);
        } else {
            $this->additionalInfo = $additionalInfo;
        }
        return $this;
    }
    /**
     * Get dates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSDate|null
     */
    public function getDates()
    {
        return isset($this->dates) ? $this->dates : null;
    }
    /**
     * Set dates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSDate $dates
     * @return \StructType\WSLinkWithDates
     */
    public function setDates(\ArrayType\ArrayOfWSDate $dates = null)
    {
        if (is_null($dates) || (is_array($dates) && empty($dates))) {
            unset($this->dates);
        } else {
            $this->dates = $dates;
        }
        return $this;
    }
    /**
     * Get link value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getLink()
    {
        return isset($this->link) ? $this->link : null;
    }
    /**
     * Set link value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $link
     * @return \StructType\WSLinkWithDates
     */
    public function setLink(\StructType\WSLink $link = null)
    {
        if (is_null($link) || (is_array($link) && empty($link))) {
            unset($this->link);
        } else {
            $this->link = $link;
        }
        return $this;
    }
}
