<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSDoorModification StructType
 * @subpackage Structs
 */
class WSDoorModification extends AbstractStructBase
{
    /**
     * The doorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $doorId;
    /**
     * The modifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSModification
     */
    public $modifications;
    /**
     * Constructor method for WSDoorModification
     * @uses WSDoorModification::setDoorId()
     * @uses WSDoorModification::setModifications()
     * @param int $doorId
     * @param \ArrayType\ArrayOfWSModification $modifications
     */
    public function __construct($doorId = null, \ArrayType\ArrayOfWSModification $modifications = null)
    {
        $this
            ->setDoorId($doorId)
            ->setModifications($modifications);
    }
    /**
     * Get doorId value
     * @return int|null
     */
    public function getDoorId()
    {
        return $this->doorId;
    }
    /**
     * Set doorId value
     * @param int $doorId
     * @return \StructType\WSDoorModification
     */
    public function setDoorId($doorId = null)
    {
        // validation for constraint: int
        if (!is_null($doorId) && !(is_int($doorId) || ctype_digit($doorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doorId, true), gettype($doorId)), __LINE__);
        }
        $this->doorId = $doorId;
        return $this;
    }
    /**
     * Get modifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSModification|null
     */
    public function getModifications()
    {
        return isset($this->modifications) ? $this->modifications : null;
    }
    /**
     * Set modifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSModification $modifications
     * @return \StructType\WSDoorModification
     */
    public function setModifications(\ArrayType\ArrayOfWSModification $modifications = null)
    {
        if (is_null($modifications) || (is_array($modifications) && empty($modifications))) {
            unset($this->modifications);
        } else {
            $this->modifications = $modifications;
        }
        return $this;
    }
}
