<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSExtension ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSExtension extends AbstractStructArrayBase
{
    /**
     * The WSExtension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSExtension[]
     */
    public $WSExtension;
    /**
     * Constructor method for ArrayOfWSExtension
     * @uses ArrayOfWSExtension::setWSExtension()
     * @param \StructType\WSExtension[] $wSExtension
     */
    public function __construct(array $wSExtension = array())
    {
        $this
            ->setWSExtension($wSExtension);
    }
    /**
     * Get WSExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSExtension[]|null
     */
    public function getWSExtension()
    {
        return isset($this->WSExtension) ? $this->WSExtension : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSExtension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSExtension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSExtensionForArrayConstraintsFromSetWSExtension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSExtensionWSExtensionItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSExtensionWSExtensionItem instanceof \StructType\WSExtension) {
                $invalidValues[] = is_object($arrayOfWSExtensionWSExtensionItem) ? get_class($arrayOfWSExtensionWSExtensionItem) : sprintf('%s(%s)', gettype($arrayOfWSExtensionWSExtensionItem), var_export($arrayOfWSExtensionWSExtensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSExtension property can only contain items of type \StructType\WSExtension, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSExtension[] $wSExtension
     * @return \ArrayType\ArrayOfWSExtension
     */
    public function setWSExtension(array $wSExtension = array())
    {
        // validation for constraint: array
        if ('' !== ($wSExtensionArrayErrorMessage = self::validateWSExtensionForArrayConstraintsFromSetWSExtension($wSExtension))) {
            throw new \InvalidArgumentException($wSExtensionArrayErrorMessage, __LINE__);
        }
        if (is_null($wSExtension) || (is_array($wSExtension) && empty($wSExtension))) {
            unset($this->WSExtension);
        } else {
            $this->WSExtension = $wSExtension;
        }
        return $this;
    }
    /**
     * Add item to WSExtension value
     * @throws \InvalidArgumentException
     * @param \StructType\WSExtension $item
     * @return \ArrayType\ArrayOfWSExtension
     */
    public function addToWSExtension(\StructType\WSExtension $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSExtension) {
            throw new \InvalidArgumentException(sprintf('The WSExtension property can only contain items of type \StructType\WSExtension, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSExtension[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSExtension|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSExtension|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSExtension|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSExtension|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSExtension|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSExtension
     */
    public function getAttributeName()
    {
        return 'WSExtension';
    }
}
