<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named addGroupPermission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddGroupPermission $parameters
     * @return \StructType\AddGroupPermissionResponse|bool
     */
    public function addGroupPermission(\StructType\AddGroupPermission $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->addGroupPermission($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddGroupPermissionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
