<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSAccountDefinition ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSAccountDefinition extends AbstractStructArrayBase
{
    /**
     * The WSAccountDefinition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSAccountDefinition[]
     */
    public $WSAccountDefinition;
    /**
     * Constructor method for ArrayOfWSAccountDefinition
     * @uses ArrayOfWSAccountDefinition::setWSAccountDefinition()
     * @param \StructType\WSAccountDefinition[] $wSAccountDefinition
     */
    public function __construct(array $wSAccountDefinition = array())
    {
        $this
            ->setWSAccountDefinition($wSAccountDefinition);
    }
    /**
     * Get WSAccountDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSAccountDefinition[]|null
     */
    public function getWSAccountDefinition()
    {
        return isset($this->WSAccountDefinition) ? $this->WSAccountDefinition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSAccountDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSAccountDefinition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSAccountDefinitionForArrayConstraintsFromSetWSAccountDefinition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSAccountDefinitionWSAccountDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSAccountDefinitionWSAccountDefinitionItem instanceof \StructType\WSAccountDefinition) {
                $invalidValues[] = is_object($arrayOfWSAccountDefinitionWSAccountDefinitionItem) ? get_class($arrayOfWSAccountDefinitionWSAccountDefinitionItem) : sprintf('%s(%s)', gettype($arrayOfWSAccountDefinitionWSAccountDefinitionItem), var_export($arrayOfWSAccountDefinitionWSAccountDefinitionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSAccountDefinition property can only contain items of type \StructType\WSAccountDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSAccountDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSAccountDefinition[] $wSAccountDefinition
     * @return \ArrayType\ArrayOfWSAccountDefinition
     */
    public function setWSAccountDefinition(array $wSAccountDefinition = array())
    {
        // validation for constraint: array
        if ('' !== ($wSAccountDefinitionArrayErrorMessage = self::validateWSAccountDefinitionForArrayConstraintsFromSetWSAccountDefinition($wSAccountDefinition))) {
            throw new \InvalidArgumentException($wSAccountDefinitionArrayErrorMessage, __LINE__);
        }
        if (is_null($wSAccountDefinition) || (is_array($wSAccountDefinition) && empty($wSAccountDefinition))) {
            unset($this->WSAccountDefinition);
        } else {
            $this->WSAccountDefinition = $wSAccountDefinition;
        }
        return $this;
    }
    /**
     * Add item to WSAccountDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\WSAccountDefinition $item
     * @return \ArrayType\ArrayOfWSAccountDefinition
     */
    public function addToWSAccountDefinition(\StructType\WSAccountDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSAccountDefinition) {
            throw new \InvalidArgumentException(sprintf('The WSAccountDefinition property can only contain items of type \StructType\WSAccountDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSAccountDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSAccountDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSAccountDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSAccountDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSAccountDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSAccountDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSAccountDefinition
     */
    public function getAttributeName()
    {
        return 'WSAccountDefinition';
    }
}
