<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSFulldayAbsenceBlock StructType
 * @subpackage Structs
 */
class WSFulldayAbsenceBlock extends AbstractStructBase
{
    /**
     * The absenceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLevelIdentification
     */
    public $absenceLevel;
    /**
     * The bookingTimestamps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSTimestamp
     */
    public $bookingTimestamps;
    /**
     * The flags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSKeyValueGroup
     */
    public $flags;
    /**
     * Constructor method for WSFulldayAbsenceBlock
     * @uses WSFulldayAbsenceBlock::setAbsenceLevel()
     * @uses WSFulldayAbsenceBlock::setBookingTimestamps()
     * @uses WSFulldayAbsenceBlock::setFlags()
     * @param \StructType\WSLevelIdentification $absenceLevel
     * @param \ArrayType\ArrayOfWSTimestamp $bookingTimestamps
     * @param \StructType\WSKeyValueGroup $flags
     */
    public function __construct(\StructType\WSLevelIdentification $absenceLevel = null, \ArrayType\ArrayOfWSTimestamp $bookingTimestamps = null, \StructType\WSKeyValueGroup $flags = null)
    {
        $this
            ->setAbsenceLevel($absenceLevel)
            ->setBookingTimestamps($bookingTimestamps)
            ->setFlags($flags);
    }
    /**
     * Get absenceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLevelIdentification|null
     */
    public function getAbsenceLevel()
    {
        return isset($this->absenceLevel) ? $this->absenceLevel : null;
    }
    /**
     * Set absenceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLevelIdentification $absenceLevel
     * @return \StructType\WSFulldayAbsenceBlock
     */
    public function setAbsenceLevel(\StructType\WSLevelIdentification $absenceLevel = null)
    {
        if (is_null($absenceLevel) || (is_array($absenceLevel) && empty($absenceLevel))) {
            unset($this->absenceLevel);
        } else {
            $this->absenceLevel = $absenceLevel;
        }
        return $this;
    }
    /**
     * Get bookingTimestamps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSTimestamp|null
     */
    public function getBookingTimestamps()
    {
        return isset($this->bookingTimestamps) ? $this->bookingTimestamps : null;
    }
    /**
     * Set bookingTimestamps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSTimestamp $bookingTimestamps
     * @return \StructType\WSFulldayAbsenceBlock
     */
    public function setBookingTimestamps(\ArrayType\ArrayOfWSTimestamp $bookingTimestamps = null)
    {
        if (is_null($bookingTimestamps) || (is_array($bookingTimestamps) && empty($bookingTimestamps))) {
            unset($this->bookingTimestamps);
        } else {
            $this->bookingTimestamps = $bookingTimestamps;
        }
        return $this;
    }
    /**
     * Get flags value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSKeyValueGroup|null
     */
    public function getFlags()
    {
        return isset($this->flags) ? $this->flags : null;
    }
    /**
     * Set flags value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSKeyValueGroup $flags
     * @return \StructType\WSFulldayAbsenceBlock
     */
    public function setFlags(\StructType\WSKeyValueGroup $flags = null)
    {
        if (is_null($flags) || (is_array($flags) && empty($flags))) {
            unset($this->flags);
        } else {
            $this->flags = $flags;
        }
        return $this;
    }
}
