<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSGroupMembership StructType
 * @subpackage Structs
 */
class WSGroupMembership extends BasicExtensibleObject
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $active;
    /**
     * The groupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $groupID;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $level;
    /**
     * The linkID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkID;
    /**
     * The linkType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkType;
    /**
     * Constructor method for WSGroupMembership
     * @uses WSGroupMembership::setActive()
     * @uses WSGroupMembership::setGroupID()
     * @uses WSGroupMembership::setId()
     * @uses WSGroupMembership::setLevel()
     * @uses WSGroupMembership::setLinkID()
     * @uses WSGroupMembership::setLinkType()
     * @param bool $active
     * @param int $groupID
     * @param int $id
     * @param int $level
     * @param int $linkID
     * @param int $linkType
     */
    public function __construct($active = null, $groupID = null, $id = null, $level = null, $linkID = null, $linkType = null)
    {
        $this
            ->setActive($active)
            ->setGroupID($groupID)
            ->setId($id)
            ->setLevel($level)
            ->setLinkID($linkID)
            ->setLinkType($linkType);
    }
    /**
     * Get active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \StructType\WSGroupMembership
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get groupID value
     * @return int|null
     */
    public function getGroupID()
    {
        return $this->groupID;
    }
    /**
     * Set groupID value
     * @param int $groupID
     * @return \StructType\WSGroupMembership
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !(is_int($groupID) || ctype_digit($groupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupID, true), gettype($groupID)), __LINE__);
        }
        $this->groupID = $groupID;
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSGroupMembership
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get level value
     * @return int|null
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @param int $level
     * @return \StructType\WSGroupMembership
     */
    public function setLevel($level = null)
    {
        // validation for constraint: int
        if (!is_null($level) && !(is_int($level) || ctype_digit($level))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
    /**
     * Get linkID value
     * @return int|null
     */
    public function getLinkID()
    {
        return $this->linkID;
    }
    /**
     * Set linkID value
     * @param int $linkID
     * @return \StructType\WSGroupMembership
     */
    public function setLinkID($linkID = null)
    {
        // validation for constraint: int
        if (!is_null($linkID) && !(is_int($linkID) || ctype_digit($linkID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkID, true), gettype($linkID)), __LINE__);
        }
        $this->linkID = $linkID;
        return $this;
    }
    /**
     * Get linkType value
     * @return int|null
     */
    public function getLinkType()
    {
        return $this->linkType;
    }
    /**
     * Set linkType value
     * @param int $linkType
     * @return \StructType\WSGroupMembership
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: int
        if (!is_null($linkType) && !(is_int($linkType) || ctype_digit($linkType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        $this->linkType = $linkType;
        return $this;
    }
}
