<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSBdeCustomPropertyDefinition StructType
 * @subpackage Structs
 */
class WSBdeCustomPropertyDefinition extends AbstractStructBase
{
    /**
     * The bookable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $bookable;
    /**
     * The combine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $combine;
    /**
     * The divisor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $divisor;
    /**
     * The extraValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSKeyValue
     */
    public $extraValues;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $format;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The linkInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkInfo;
    /**
     * The linkType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $linkType;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The recalcOnChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $recalcOnChange;
    /**
     * The singleton
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $singleton;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $type;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unit;
    /**
     * The variable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $variable;
    /**
     * Constructor method for WSBdeCustomPropertyDefinition
     * @uses WSBdeCustomPropertyDefinition::setBookable()
     * @uses WSBdeCustomPropertyDefinition::setCombine()
     * @uses WSBdeCustomPropertyDefinition::setDivisor()
     * @uses WSBdeCustomPropertyDefinition::setExtraValues()
     * @uses WSBdeCustomPropertyDefinition::setFormat()
     * @uses WSBdeCustomPropertyDefinition::setId()
     * @uses WSBdeCustomPropertyDefinition::setLinkInfo()
     * @uses WSBdeCustomPropertyDefinition::setLinkType()
     * @uses WSBdeCustomPropertyDefinition::setName()
     * @uses WSBdeCustomPropertyDefinition::setRecalcOnChange()
     * @uses WSBdeCustomPropertyDefinition::setSingleton()
     * @uses WSBdeCustomPropertyDefinition::setType()
     * @uses WSBdeCustomPropertyDefinition::setUnit()
     * @uses WSBdeCustomPropertyDefinition::setVariable()
     * @param bool $bookable
     * @param bool $combine
     * @param int $divisor
     * @param \ArrayType\ArrayOfWSKeyValue $extraValues
     * @param string $format
     * @param int $id
     * @param int $linkInfo
     * @param int $linkType
     * @param string $name
     * @param bool $recalcOnChange
     * @param bool $singleton
     * @param int $type
     * @param string $unit
     * @param string $variable
     */
    public function __construct($bookable = null, $combine = null, $divisor = null, \ArrayType\ArrayOfWSKeyValue $extraValues = null, $format = null, $id = null, $linkInfo = null, $linkType = null, $name = null, $recalcOnChange = null, $singleton = null, $type = null, $unit = null, $variable = null)
    {
        $this
            ->setBookable($bookable)
            ->setCombine($combine)
            ->setDivisor($divisor)
            ->setExtraValues($extraValues)
            ->setFormat($format)
            ->setId($id)
            ->setLinkInfo($linkInfo)
            ->setLinkType($linkType)
            ->setName($name)
            ->setRecalcOnChange($recalcOnChange)
            ->setSingleton($singleton)
            ->setType($type)
            ->setUnit($unit)
            ->setVariable($variable);
    }
    /**
     * Get bookable value
     * @return bool|null
     */
    public function getBookable()
    {
        return $this->bookable;
    }
    /**
     * Set bookable value
     * @param bool $bookable
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setBookable($bookable = null)
    {
        // validation for constraint: boolean
        if (!is_null($bookable) && !is_bool($bookable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bookable, true), gettype($bookable)), __LINE__);
        }
        $this->bookable = $bookable;
        return $this;
    }
    /**
     * Get combine value
     * @return bool|null
     */
    public function getCombine()
    {
        return $this->combine;
    }
    /**
     * Set combine value
     * @param bool $combine
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setCombine($combine = null)
    {
        // validation for constraint: boolean
        if (!is_null($combine) && !is_bool($combine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($combine, true), gettype($combine)), __LINE__);
        }
        $this->combine = $combine;
        return $this;
    }
    /**
     * Get divisor value
     * @return int|null
     */
    public function getDivisor()
    {
        return $this->divisor;
    }
    /**
     * Set divisor value
     * @param int $divisor
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setDivisor($divisor = null)
    {
        // validation for constraint: int
        if (!is_null($divisor) && !(is_int($divisor) || ctype_digit($divisor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($divisor, true), gettype($divisor)), __LINE__);
        }
        $this->divisor = $divisor;
        return $this;
    }
    /**
     * Get extraValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSKeyValue|null
     */
    public function getExtraValues()
    {
        return isset($this->extraValues) ? $this->extraValues : null;
    }
    /**
     * Set extraValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSKeyValue $extraValues
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setExtraValues(\ArrayType\ArrayOfWSKeyValue $extraValues = null)
    {
        if (is_null($extraValues) || (is_array($extraValues) && empty($extraValues))) {
            unset($this->extraValues);
        } else {
            $this->extraValues = $extraValues;
        }
        return $this;
    }
    /**
     * Get format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormat()
    {
        return isset($this->format) ? $this->format : null;
    }
    /**
     * Set format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $format
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        if (is_null($format) || (is_array($format) && empty($format))) {
            unset($this->format);
        } else {
            $this->format = $format;
        }
        return $this;
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get linkInfo value
     * @return int|null
     */
    public function getLinkInfo()
    {
        return $this->linkInfo;
    }
    /**
     * Set linkInfo value
     * @param int $linkInfo
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setLinkInfo($linkInfo = null)
    {
        // validation for constraint: int
        if (!is_null($linkInfo) && !(is_int($linkInfo) || ctype_digit($linkInfo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkInfo, true), gettype($linkInfo)), __LINE__);
        }
        $this->linkInfo = $linkInfo;
        return $this;
    }
    /**
     * Get linkType value
     * @return int|null
     */
    public function getLinkType()
    {
        return $this->linkType;
    }
    /**
     * Set linkType value
     * @param int $linkType
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: int
        if (!is_null($linkType) && !(is_int($linkType) || ctype_digit($linkType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        $this->linkType = $linkType;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get recalcOnChange value
     * @return bool|null
     */
    public function getRecalcOnChange()
    {
        return $this->recalcOnChange;
    }
    /**
     * Set recalcOnChange value
     * @param bool $recalcOnChange
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setRecalcOnChange($recalcOnChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($recalcOnChange) && !is_bool($recalcOnChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recalcOnChange, true), gettype($recalcOnChange)), __LINE__);
        }
        $this->recalcOnChange = $recalcOnChange;
        return $this;
    }
    /**
     * Get singleton value
     * @return bool|null
     */
    public function getSingleton()
    {
        return $this->singleton;
    }
    /**
     * Set singleton value
     * @param bool $singleton
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setSingleton($singleton = null)
    {
        // validation for constraint: boolean
        if (!is_null($singleton) && !is_bool($singleton)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($singleton, true), gettype($singleton)), __LINE__);
        }
        $this->singleton = $singleton;
        return $this;
    }
    /**
     * Get type value
     * @return int|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param int $type
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get unit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnit()
    {
        return isset($this->unit) ? $this->unit : null;
    }
    /**
     * Set unit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unit
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        if (is_null($unit) || (is_array($unit) && empty($unit))) {
            unset($this->unit);
        } else {
            $this->unit = $unit;
        }
        return $this;
    }
    /**
     * Get variable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVariable()
    {
        return isset($this->variable) ? $this->variable : null;
    }
    /**
     * Set variable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $variable
     * @return \StructType\WSBdeCustomPropertyDefinition
     */
    public function setVariable($variable = null)
    {
        // validation for constraint: string
        if (!is_null($variable) && !is_string($variable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($variable, true), gettype($variable)), __LINE__);
        }
        if (is_null($variable) || (is_array($variable) && empty($variable))) {
            unset($this->variable);
        } else {
            $this->variable = $variable;
        }
        return $this;
    }
}
