<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSPropertyDefinition ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSPropertyDefinition extends AbstractStructArrayBase
{
    /**
     * The WSPropertyDefinition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPropertyDefinition[]
     */
    public $WSPropertyDefinition;
    /**
     * Constructor method for ArrayOfWSPropertyDefinition
     * @uses ArrayOfWSPropertyDefinition::setWSPropertyDefinition()
     * @param \StructType\WSPropertyDefinition[] $wSPropertyDefinition
     */
    public function __construct(array $wSPropertyDefinition = array())
    {
        $this
            ->setWSPropertyDefinition($wSPropertyDefinition);
    }
    /**
     * Get WSPropertyDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPropertyDefinition[]|null
     */
    public function getWSPropertyDefinition()
    {
        return isset($this->WSPropertyDefinition) ? $this->WSPropertyDefinition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSPropertyDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSPropertyDefinition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSPropertyDefinitionForArrayConstraintsFromSetWSPropertyDefinition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSPropertyDefinitionWSPropertyDefinitionItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSPropertyDefinitionWSPropertyDefinitionItem instanceof \StructType\WSPropertyDefinition) {
                $invalidValues[] = is_object($arrayOfWSPropertyDefinitionWSPropertyDefinitionItem) ? get_class($arrayOfWSPropertyDefinitionWSPropertyDefinitionItem) : sprintf('%s(%s)', gettype($arrayOfWSPropertyDefinitionWSPropertyDefinitionItem), var_export($arrayOfWSPropertyDefinitionWSPropertyDefinitionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSPropertyDefinition property can only contain items of type \StructType\WSPropertyDefinition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSPropertyDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSPropertyDefinition[] $wSPropertyDefinition
     * @return \ArrayType\ArrayOfWSPropertyDefinition
     */
    public function setWSPropertyDefinition(array $wSPropertyDefinition = array())
    {
        // validation for constraint: array
        if ('' !== ($wSPropertyDefinitionArrayErrorMessage = self::validateWSPropertyDefinitionForArrayConstraintsFromSetWSPropertyDefinition($wSPropertyDefinition))) {
            throw new \InvalidArgumentException($wSPropertyDefinitionArrayErrorMessage, __LINE__);
        }
        if (is_null($wSPropertyDefinition) || (is_array($wSPropertyDefinition) && empty($wSPropertyDefinition))) {
            unset($this->WSPropertyDefinition);
        } else {
            $this->WSPropertyDefinition = $wSPropertyDefinition;
        }
        return $this;
    }
    /**
     * Add item to WSPropertyDefinition value
     * @throws \InvalidArgumentException
     * @param \StructType\WSPropertyDefinition $item
     * @return \ArrayType\ArrayOfWSPropertyDefinition
     */
    public function addToWSPropertyDefinition(\StructType\WSPropertyDefinition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSPropertyDefinition) {
            throw new \InvalidArgumentException(sprintf('The WSPropertyDefinition property can only contain items of type \StructType\WSPropertyDefinition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSPropertyDefinition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSPropertyDefinition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSPropertyDefinition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSPropertyDefinition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSPropertyDefinition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSPropertyDefinition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSPropertyDefinition
     */
    public function getAttributeName()
    {
        return 'WSPropertyDefinition';
    }
}
