<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSTaskActionResult StructType
 * @subpackage Structs
 */
class WSTaskActionResult extends AbstractStructBase
{
    /**
     * The task
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTask
     */
    public $task;
    /**
     * Constructor method for WSTaskActionResult
     * @uses WSTaskActionResult::setTask()
     * @param \StructType\WSTask $task
     */
    public function __construct(\StructType\WSTask $task = null)
    {
        $this
            ->setTask($task);
    }
    /**
     * Get task value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTask|null
     */
    public function getTask()
    {
        return isset($this->task) ? $this->task : null;
    }
    /**
     * Set task value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTask $task
     * @return \StructType\WSTaskActionResult
     */
    public function setTask(\StructType\WSTask $task = null)
    {
        if (is_null($task) || (is_array($task) && empty($task))) {
            unset($this->task);
        } else {
            $this->task = $task;
        }
        return $this;
    }
}
