<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSExtensibleBooking StructType
 * @subpackage Structs
 */
class WSExtensibleBooking extends BasicExtensibleObject
{
    /**
     * The fixedStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fixedStart;
    /**
     * The fixedStop
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fixedStop;
    /**
     * The fullDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fullDay;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The levels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWSLevelIdentification
     */
    public $levels;
    /**
     * The personID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $personID;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $timestamp;
    /**
     * Constructor method for WSExtensibleBooking
     * @uses WSExtensibleBooking::setFixedStart()
     * @uses WSExtensibleBooking::setFixedStop()
     * @uses WSExtensibleBooking::setFullDay()
     * @uses WSExtensibleBooking::setId()
     * @uses WSExtensibleBooking::setLevels()
     * @uses WSExtensibleBooking::setPersonID()
     * @uses WSExtensibleBooking::setTimestamp()
     * @param bool $fixedStart
     * @param bool $fixedStop
     * @param bool $fullDay
     * @param int $id
     * @param \ArrayType\ArrayOfWSLevelIdentification $levels
     * @param string $personID
     * @param \StructType\WSTimestamp $timestamp
     */
    public function __construct($fixedStart = null, $fixedStop = null, $fullDay = null, $id = null, \ArrayType\ArrayOfWSLevelIdentification $levels = null, $personID = null, \StructType\WSTimestamp $timestamp = null)
    {
        $this
            ->setFixedStart($fixedStart)
            ->setFixedStop($fixedStop)
            ->setFullDay($fullDay)
            ->setId($id)
            ->setLevels($levels)
            ->setPersonID($personID)
            ->setTimestamp($timestamp);
    }
    /**
     * Get fixedStart value
     * @return bool|null
     */
    public function getFixedStart()
    {
        return $this->fixedStart;
    }
    /**
     * Set fixedStart value
     * @param bool $fixedStart
     * @return \StructType\WSExtensibleBooking
     */
    public function setFixedStart($fixedStart = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixedStart) && !is_bool($fixedStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixedStart, true), gettype($fixedStart)), __LINE__);
        }
        $this->fixedStart = $fixedStart;
        return $this;
    }
    /**
     * Get fixedStop value
     * @return bool|null
     */
    public function getFixedStop()
    {
        return $this->fixedStop;
    }
    /**
     * Set fixedStop value
     * @param bool $fixedStop
     * @return \StructType\WSExtensibleBooking
     */
    public function setFixedStop($fixedStop = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixedStop) && !is_bool($fixedStop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixedStop, true), gettype($fixedStop)), __LINE__);
        }
        $this->fixedStop = $fixedStop;
        return $this;
    }
    /**
     * Get fullDay value
     * @return bool|null
     */
    public function getFullDay()
    {
        return $this->fullDay;
    }
    /**
     * Set fullDay value
     * @param bool $fullDay
     * @return \StructType\WSExtensibleBooking
     */
    public function setFullDay($fullDay = null)
    {
        // validation for constraint: boolean
        if (!is_null($fullDay) && !is_bool($fullDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fullDay, true), gettype($fullDay)), __LINE__);
        }
        $this->fullDay = $fullDay;
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSExtensibleBooking
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get levels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWSLevelIdentification|null
     */
    public function getLevels()
    {
        return isset($this->levels) ? $this->levels : null;
    }
    /**
     * Set levels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWSLevelIdentification $levels
     * @return \StructType\WSExtensibleBooking
     */
    public function setLevels(\ArrayType\ArrayOfWSLevelIdentification $levels = null)
    {
        if (is_null($levels) || (is_array($levels) && empty($levels))) {
            unset($this->levels);
        } else {
            $this->levels = $levels;
        }
        return $this;
    }
    /**
     * Get personID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonID()
    {
        return isset($this->personID) ? $this->personID : null;
    }
    /**
     * Set personID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personID
     * @return \StructType\WSExtensibleBooking
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: string
        if (!is_null($personID) && !is_string($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        if (is_null($personID) || (is_array($personID) && empty($personID))) {
            unset($this->personID);
        } else {
            $this->personID = $personID;
        }
        return $this;
    }
    /**
     * Get timestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getTimestamp()
    {
        return isset($this->timestamp) ? $this->timestamp : null;
    }
    /**
     * Set timestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $timestamp
     * @return \StructType\WSExtensibleBooking
     */
    public function setTimestamp(\StructType\WSTimestamp $timestamp = null)
    {
        if (is_null($timestamp) || (is_array($timestamp) && empty($timestamp))) {
            unset($this->timestamp);
        } else {
            $this->timestamp = $timestamp;
        }
        return $this;
    }
}
