<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateLevel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLevel $parameters
     * @return \StructType\UpdateLevelResponse|bool
     */
    public function updateLevel(\StructType\UpdateLevel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLevel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGroups $parameters
     * @return \StructType\UpdateGroupsResponse|bool
     */
    public function updateGroups(\StructType\UpdateGroups $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCustomer2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomer2 $parameters
     * @return \StructType\UpdateCustomer2Response|bool
     */
    public function updateCustomer2(\StructType\UpdateCustomer2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCustomer2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateConfigurationTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateConfigurationTime $parameters
     * @return \StructType\UpdateConfigurationTimeResponse|bool
     */
    public function updateConfigurationTime(\StructType\UpdateConfigurationTime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateConfigurationTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCommunicationTime
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCommunicationTime $parameters
     * @return \StructType\UpdateCommunicationTimeResponse|bool
     */
    public function updateCommunicationTime(\StructType\UpdateCommunicationTime $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCommunicationTime($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCustomersE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomersE $parameters
     * @return \StructType\UpdateCustomersEResponse|bool
     */
    public function updateCustomersE(\StructType\UpdateCustomersE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCustomersE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateTaskAssignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateTaskAssignment $parameters
     * @return \StructType\UpdateTaskAssignmentResponse|bool
     */
    public function updateTaskAssignment(\StructType\UpdateTaskAssignment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateTaskAssignment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateGenericProperties
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateGenericProperties $parameters
     * @return \StructType\UpdateGenericPropertiesResponse|bool
     */
    public function updateGenericProperties(\StructType\UpdateGenericProperties $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateGenericProperties($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomer $parameters
     * @return \StructType\UpdateCustomerResponse|bool
     */
    public function updateCustomer(\StructType\UpdateCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLevelsE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateLevelsE $parameters
     * @return \StructType\UpdateLevelsEResponse|bool
     */
    public function updateLevelsE(\StructType\UpdateLevelsE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLevelsE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updatePersonsE
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePersonsE $parameters
     * @return \StructType\UpdatePersonsEResponse|bool
     */
    public function updatePersonsE(\StructType\UpdatePersonsE $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updatePersonsE($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateCommunicationTimeResponse|\StructType\UpdateConfigurationTimeResponse|\StructType\UpdateCustomer2Response|\StructType\UpdateCustomerResponse|\StructType\UpdateCustomersEResponse|\StructType\UpdateGenericPropertiesResponse|\StructType\UpdateGroupsResponse|\StructType\UpdateLevelResponse|\StructType\UpdateLevelsEResponse|\StructType\UpdatePersonsEResponse|\StructType\UpdateTaskAssignmentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
