<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remove ServiceType
 * @subpackage Services
 */
class Remove extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named removeGroupPermission
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoveGroupPermission $parameters
     * @return \StructType\RemoveGroupPermissionResponse|bool
     */
    public function removeGroupPermission(\StructType\RemoveGroupPermission $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->removeGroupPermission($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoveGroupPermissionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
