<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSModification ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSModification extends AbstractStructArrayBase
{
    /**
     * The WSModification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSModification[]
     */
    public $WSModification;
    /**
     * Constructor method for ArrayOfWSModification
     * @uses ArrayOfWSModification::setWSModification()
     * @param \StructType\WSModification[] $wSModification
     */
    public function __construct(array $wSModification = array())
    {
        $this
            ->setWSModification($wSModification);
    }
    /**
     * Get WSModification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSModification[]|null
     */
    public function getWSModification()
    {
        return isset($this->WSModification) ? $this->WSModification : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSModification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSModification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSModificationForArrayConstraintsFromSetWSModification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSModificationWSModificationItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSModificationWSModificationItem instanceof \StructType\WSModification) {
                $invalidValues[] = is_object($arrayOfWSModificationWSModificationItem) ? get_class($arrayOfWSModificationWSModificationItem) : sprintf('%s(%s)', gettype($arrayOfWSModificationWSModificationItem), var_export($arrayOfWSModificationWSModificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSModification property can only contain items of type \StructType\WSModification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSModification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSModification[] $wSModification
     * @return \ArrayType\ArrayOfWSModification
     */
    public function setWSModification(array $wSModification = array())
    {
        // validation for constraint: array
        if ('' !== ($wSModificationArrayErrorMessage = self::validateWSModificationForArrayConstraintsFromSetWSModification($wSModification))) {
            throw new \InvalidArgumentException($wSModificationArrayErrorMessage, __LINE__);
        }
        if (is_null($wSModification) || (is_array($wSModification) && empty($wSModification))) {
            unset($this->WSModification);
        } else {
            $this->WSModification = $wSModification;
        }
        return $this;
    }
    /**
     * Add item to WSModification value
     * @throws \InvalidArgumentException
     * @param \StructType\WSModification $item
     * @return \ArrayType\ArrayOfWSModification
     */
    public function addToWSModification(\StructType\WSModification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSModification) {
            throw new \InvalidArgumentException(sprintf('The WSModification property can only contain items of type \StructType\WSModification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSModification[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSModification|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSModification|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSModification|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSModification|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSModification|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSModification
     */
    public function getAttributeName()
    {
        return 'WSModification';
    }
}
