<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invoke ServiceType
 * @subpackage Services
 */
class Invoke extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named invokeScriptedFunction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InvokeScriptedFunction $parameters
     * @return \StructType\InvokeScriptedFunctionResponse|bool
     */
    public function invokeScriptedFunction(\StructType\InvokeScriptedFunction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->invokeScriptedFunction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InvokeScriptedFunctionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
