<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSLevel StructType
 * @subpackage Structs
 */
class WSLevel extends AbstractStructBase
{
    /**
     * The absence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $absence;
    /**
     * The active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $active;
    /**
     * The argb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $argb;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The customerReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $customerReference;
    /**
     * The estimation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $estimation;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $id;
    /**
     * The levelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $levelID;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $text;
    /**
     * Constructor method for WSLevel
     * @uses WSLevel::setAbsence()
     * @uses WSLevel::setActive()
     * @uses WSLevel::setArgb()
     * @uses WSLevel::setCode()
     * @uses WSLevel::setCustomerReference()
     * @uses WSLevel::setEstimation()
     * @uses WSLevel::setId()
     * @uses WSLevel::setLevelID()
     * @uses WSLevel::setText()
     * @param bool $absence
     * @param bool $active
     * @param int $argb
     * @param string $code
     * @param string $customerReference
     * @param int $estimation
     * @param int $id
     * @param int $levelID
     * @param string $text
     */
    public function __construct($absence = null, $active = null, $argb = null, $code = null, $customerReference = null, $estimation = null, $id = null, $levelID = null, $text = null)
    {
        $this
            ->setAbsence($absence)
            ->setActive($active)
            ->setArgb($argb)
            ->setCode($code)
            ->setCustomerReference($customerReference)
            ->setEstimation($estimation)
            ->setId($id)
            ->setLevelID($levelID)
            ->setText($text);
    }
    /**
     * Get absence value
     * @return bool|null
     */
    public function getAbsence()
    {
        return $this->absence;
    }
    /**
     * Set absence value
     * @param bool $absence
     * @return \StructType\WSLevel
     */
    public function setAbsence($absence = null)
    {
        // validation for constraint: boolean
        if (!is_null($absence) && !is_bool($absence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($absence, true), gettype($absence)), __LINE__);
        }
        $this->absence = $absence;
        return $this;
    }
    /**
     * Get active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \StructType\WSLevel
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get argb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArgb()
    {
        return isset($this->argb) ? $this->argb : null;
    }
    /**
     * Set argb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $argb
     * @return \StructType\WSLevel
     */
    public function setArgb($argb = null)
    {
        // validation for constraint: int
        if (!is_null($argb) && !(is_int($argb) || ctype_digit($argb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($argb, true), gettype($argb)), __LINE__);
        }
        if (is_null($argb) || (is_array($argb) && empty($argb))) {
            unset($this->argb);
        } else {
            $this->argb = $argb;
        }
        return $this;
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\WSLevel
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get customerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerReference()
    {
        return isset($this->customerReference) ? $this->customerReference : null;
    }
    /**
     * Set customerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerReference
     * @return \StructType\WSLevel
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        if (is_null($customerReference) || (is_array($customerReference) && empty($customerReference))) {
            unset($this->customerReference);
        } else {
            $this->customerReference = $customerReference;
        }
        return $this;
    }
    /**
     * Get estimation value
     * @return int|null
     */
    public function getEstimation()
    {
        return $this->estimation;
    }
    /**
     * Set estimation value
     * @param int $estimation
     * @return \StructType\WSLevel
     */
    public function setEstimation($estimation = null)
    {
        // validation for constraint: int
        if (!is_null($estimation) && !(is_int($estimation) || ctype_digit($estimation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimation, true), gettype($estimation)), __LINE__);
        }
        $this->estimation = $estimation;
        return $this;
    }
    /**
     * Get id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getId()
    {
        return isset($this->id) ? $this->id : null;
    }
    /**
     * Set id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $id
     * @return \StructType\WSLevel
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->id);
        } else {
            $this->id = $id;
        }
        return $this;
    }
    /**
     * Get levelID value
     * @return int|null
     */
    public function getLevelID()
    {
        return $this->levelID;
    }
    /**
     * Set levelID value
     * @param int $levelID
     * @return \StructType\WSLevel
     */
    public function setLevelID($levelID = null)
    {
        // validation for constraint: int
        if (!is_null($levelID) && !(is_int($levelID) || ctype_digit($levelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($levelID, true), gettype($levelID)), __LINE__);
        }
        $this->levelID = $levelID;
        return $this;
    }
    /**
     * Get text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->text) ? $this->text : null;
    }
    /**
     * Set text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\WSLevel
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->text);
        } else {
            $this->text = $text;
        }
        return $this;
    }
}
