<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSCustomTerminalRecord StructType
 * @subpackage Structs
 */
class WSCustomTerminalRecord extends AbstractStructBase
{
    /**
     * The data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $data;
    /**
     * The recordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recordNumber;
    /**
     * The recordSubNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $recordSubNumber;
    /**
     * Constructor method for WSCustomTerminalRecord
     * @uses WSCustomTerminalRecord::setData()
     * @uses WSCustomTerminalRecord::setRecordNumber()
     * @uses WSCustomTerminalRecord::setRecordSubNumber()
     * @param string $data
     * @param int $recordNumber
     * @param int $recordSubNumber
     */
    public function __construct($data = null, $recordNumber = null, $recordSubNumber = null)
    {
        $this
            ->setData($data)
            ->setRecordNumber($recordNumber)
            ->setRecordSubNumber($recordSubNumber);
    }
    /**
     * Get data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->data) ? $this->data : null;
    }
    /**
     * Set data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \StructType\WSCustomTerminalRecord
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->data);
        } else {
            $this->data = $data;
        }
        return $this;
    }
    /**
     * Get recordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->recordNumber;
    }
    /**
     * Set recordNumber value
     * @param int $recordNumber
     * @return \StructType\WSCustomTerminalRecord
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->recordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get recordSubNumber value
     * @return int|null
     */
    public function getRecordSubNumber()
    {
        return $this->recordSubNumber;
    }
    /**
     * Set recordSubNumber value
     * @param int $recordSubNumber
     * @return \StructType\WSCustomTerminalRecord
     */
    public function setRecordSubNumber($recordSubNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordSubNumber) && !(is_int($recordSubNumber) || ctype_digit($recordSubNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordSubNumber, true), gettype($recordSubNumber)), __LINE__);
        }
        $this->recordSubNumber = $recordSubNumber;
        return $this;
    }
}
