<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSKeyValue ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSKeyValue extends AbstractStructArrayBase
{
    /**
     * The WSKeyValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSKeyValue[]
     */
    public $WSKeyValue;
    /**
     * Constructor method for ArrayOfWSKeyValue
     * @uses ArrayOfWSKeyValue::setWSKeyValue()
     * @param \StructType\WSKeyValue[] $wSKeyValue
     */
    public function __construct(array $wSKeyValue = array())
    {
        $this
            ->setWSKeyValue($wSKeyValue);
    }
    /**
     * Get WSKeyValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSKeyValue[]|null
     */
    public function getWSKeyValue()
    {
        return isset($this->WSKeyValue) ? $this->WSKeyValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSKeyValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSKeyValueForArrayConstraintsFromSetWSKeyValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSKeyValueWSKeyValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSKeyValueWSKeyValueItem instanceof \StructType\WSKeyValue) {
                $invalidValues[] = is_object($arrayOfWSKeyValueWSKeyValueItem) ? get_class($arrayOfWSKeyValueWSKeyValueItem) : sprintf('%s(%s)', gettype($arrayOfWSKeyValueWSKeyValueItem), var_export($arrayOfWSKeyValueWSKeyValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSKeyValue property can only contain items of type \StructType\WSKeyValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSKeyValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSKeyValue[] $wSKeyValue
     * @return \ArrayType\ArrayOfWSKeyValue
     */
    public function setWSKeyValue(array $wSKeyValue = array())
    {
        // validation for constraint: array
        if ('' !== ($wSKeyValueArrayErrorMessage = self::validateWSKeyValueForArrayConstraintsFromSetWSKeyValue($wSKeyValue))) {
            throw new \InvalidArgumentException($wSKeyValueArrayErrorMessage, __LINE__);
        }
        if (is_null($wSKeyValue) || (is_array($wSKeyValue) && empty($wSKeyValue))) {
            unset($this->WSKeyValue);
        } else {
            $this->WSKeyValue = $wSKeyValue;
        }
        return $this;
    }
    /**
     * Add item to WSKeyValue value
     * @throws \InvalidArgumentException
     * @param \StructType\WSKeyValue $item
     * @return \ArrayType\ArrayOfWSKeyValue
     */
    public function addToWSKeyValue(\StructType\WSKeyValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSKeyValue) {
            throw new \InvalidArgumentException(sprintf('The WSKeyValue property can only contain items of type \StructType\WSKeyValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSKeyValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSKeyValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSKeyValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSKeyValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSKeyValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSKeyValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSKeyValue
     */
    public function getAttributeName()
    {
        return 'WSKeyValue';
    }
}
