<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSCustomTerminalRecord ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSCustomTerminalRecord extends AbstractStructArrayBase
{
    /**
     * The WSCustomTerminalRecord
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSCustomTerminalRecord[]
     */
    public $WSCustomTerminalRecord;
    /**
     * Constructor method for ArrayOfWSCustomTerminalRecord
     * @uses ArrayOfWSCustomTerminalRecord::setWSCustomTerminalRecord()
     * @param \StructType\WSCustomTerminalRecord[] $wSCustomTerminalRecord
     */
    public function __construct(array $wSCustomTerminalRecord = array())
    {
        $this
            ->setWSCustomTerminalRecord($wSCustomTerminalRecord);
    }
    /**
     * Get WSCustomTerminalRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSCustomTerminalRecord[]|null
     */
    public function getWSCustomTerminalRecord()
    {
        return isset($this->WSCustomTerminalRecord) ? $this->WSCustomTerminalRecord : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSCustomTerminalRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSCustomTerminalRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSCustomTerminalRecordForArrayConstraintsFromSetWSCustomTerminalRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSCustomTerminalRecordWSCustomTerminalRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSCustomTerminalRecordWSCustomTerminalRecordItem instanceof \StructType\WSCustomTerminalRecord) {
                $invalidValues[] = is_object($arrayOfWSCustomTerminalRecordWSCustomTerminalRecordItem) ? get_class($arrayOfWSCustomTerminalRecordWSCustomTerminalRecordItem) : sprintf('%s(%s)', gettype($arrayOfWSCustomTerminalRecordWSCustomTerminalRecordItem), var_export($arrayOfWSCustomTerminalRecordWSCustomTerminalRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSCustomTerminalRecord property can only contain items of type \StructType\WSCustomTerminalRecord, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSCustomTerminalRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomTerminalRecord[] $wSCustomTerminalRecord
     * @return \ArrayType\ArrayOfWSCustomTerminalRecord
     */
    public function setWSCustomTerminalRecord(array $wSCustomTerminalRecord = array())
    {
        // validation for constraint: array
        if ('' !== ($wSCustomTerminalRecordArrayErrorMessage = self::validateWSCustomTerminalRecordForArrayConstraintsFromSetWSCustomTerminalRecord($wSCustomTerminalRecord))) {
            throw new \InvalidArgumentException($wSCustomTerminalRecordArrayErrorMessage, __LINE__);
        }
        if (is_null($wSCustomTerminalRecord) || (is_array($wSCustomTerminalRecord) && empty($wSCustomTerminalRecord))) {
            unset($this->WSCustomTerminalRecord);
        } else {
            $this->WSCustomTerminalRecord = $wSCustomTerminalRecord;
        }
        return $this;
    }
    /**
     * Add item to WSCustomTerminalRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\WSCustomTerminalRecord $item
     * @return \ArrayType\ArrayOfWSCustomTerminalRecord
     */
    public function addToWSCustomTerminalRecord(\StructType\WSCustomTerminalRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSCustomTerminalRecord) {
            throw new \InvalidArgumentException(sprintf('The WSCustomTerminalRecord property can only contain items of type \StructType\WSCustomTerminalRecord, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSCustomTerminalRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSCustomTerminalRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSCustomTerminalRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSCustomTerminalRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSCustomTerminalRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSCustomTerminalRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSCustomTerminalRecord
     */
    public function getAttributeName()
    {
        return 'WSCustomTerminalRecord';
    }
}
