<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://zsw.finkzeit.at/ws?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://zsw.finkzeit.at/ws?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getAllVehicleStatuses operation/method
 */
if ($get->getAllVehicleStatuses(new \StructType\GetAllVehicleStatuses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsByLevelID2 operation/method
 */
if ($get->getLevelsByLevelID2(new \StructType\GetLevelsByLevelID2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTerminalsByTypeE operation/method
 */
if ($get->getTerminalsByTypeE(new \StructType\GetTerminalsByTypeE()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomConfigurationForTerminalNr operation/method
 */
if ($get->getCustomConfigurationForTerminalNr(new \StructType\GetCustomConfigurationForTerminalNr()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGenericProperties operation/method
 */
if ($get->getGenericProperties(new \StructType\GetGenericProperties()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGroups operation/method
 */
if ($get->getGroups(new \StructType\GetGroups()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedBookingIDsByBookingTS operation/method
 */
if ($get->getDeletedBookingIDsByBookingTS(new \StructType\GetDeletedBookingIDsByBookingTS()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllPropertyDefinitions operation/method
 */
if ($get->getAllPropertyDefinitions(new \StructType\GetAllPropertyDefinitions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLockDateByPersonDBID operation/method
 */
if ($get->getLockDateByPersonDBID(new \StructType\GetLockDateByPersonDBID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountsByPersonDBID operation/method
 */
if ($get->getAccountsByPersonDBID(new \StructType\GetAccountsByPersonDBID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTasksByChangeTS operation/method
 */
if ($get->getTasksByChangeTS(new \StructType\GetTasksByChangeTS()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllBdeCustomPropertyDefinitions operation/method
 */
if ($get->getAllBdeCustomPropertyDefinitions(new \StructType\GetAllBdeCustomPropertyDefinitions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCalendarEntriesByTimeRange operation/method
 */
if ($get->getCalendarEntriesByTimeRange(new \StructType\GetCalendarEntriesByTimeRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsByLevelID operation/method
 */
if ($get->getLevelsByLevelID(new \StructType\GetLevelsByLevelID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getChangedForms operation/method
 */
if ($get->getChangedForms(new \StructType\GetChangedForms()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTime operation/method
 */
if ($get->getTime(new \StructType\GetTime()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFullDayAbsencesByPersonDBID operation/method
 */
if ($get->getFullDayAbsencesByPersonDBID(new \StructType\GetFullDayAbsencesByPersonDBID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEntryTerminal operation/method
 */
if ($get->getEntryTerminal(new \StructType\GetEntryTerminal()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeletedBookingIDs operation/method
 */
if ($get->getDeletedBookingIDs(new \StructType\GetDeletedBookingIDs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllAccountDefinitions operation/method
 */
if ($get->getAllAccountDefinitions(new \StructType\GetAllAccountDefinitions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountSumsForAll operation/method
 */
if ($get->getAccountSumsForAll(new \StructType\GetAccountSumsForAll()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPermissionsByDoorDBID operation/method
 */
if ($get->getPermissionsByDoorDBID(new \StructType\GetPermissionsByDoorDBID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountSumsByPersonID operation/method
 */
if ($get->getAccountSumsByPersonID(new \StructType\GetAccountSumsByPersonID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomTerminalInformation operation/method
 */
if ($get->getCustomTerminalInformation(new \StructType\GetCustomTerminalInformation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHoursByLevels operation/method
 */
if ($get->getHoursByLevels(new \StructType\GetHoursByLevels()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHoursByLevelDBIDs operation/method
 */
if ($get->getHoursByLevelDBIDs(new \StructType\GetHoursByLevelDBIDs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGroupMembershipsForMember operation/method
 */
if ($get->getGroupMembershipsForMember(new \StructType\GetGroupMembershipsForMember()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllGroups operation/method
 */
if ($get->getAllGroups(new \StructType\GetAllGroups()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getStartDate operation/method
 */
if ($get->getStartDate(new \StructType\GetStartDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingPairsByLevelDBIDs operation/method
 */
if ($get->getBookingPairsByLevelDBIDs(new \StructType\GetBookingPairsByLevelDBIDs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTrips operation/method
 */
if ($get->getTrips(new \StructType\GetTrips()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSessionTimeout operation/method
 */
if ($get->getSessionTimeout(new \StructType\GetSessionTimeout()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsEByIdentification operation/method
 */
if ($get->getLevelsEByIdentification(new \StructType\GetLevelsEByIdentification()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPersonsWithBookingChangesInRange operation/method
 */
if ($get->getPersonsWithBookingChangesInRange(new \StructType\GetPersonsWithBookingChangesInRange()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getWaypointsOfVehicle operation/method
 */
if ($get->getWaypointsOfVehicle(new \StructType\GetWaypointsOfVehicle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllVehicles operation/method
 */
if ($get->getAllVehicles(new \StructType\GetAllVehicles()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllCustomers operation/method
 */
if ($get->getAllCustomers(new \StructType\GetAllCustomers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCustomersByDBID operation/method
 */
if ($get->getCustomersByDBID(new \StructType\GetCustomersByDBID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEmployeesE operation/method
 */
if ($get->getEmployeesE(new \StructType\GetEmployeesE()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getChangedBDEBookingPairs operation/method
 */
if ($get->getChangedBDEBookingPairs(new \StructType\GetChangedBDEBookingPairs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFullDayAbsencesByPersonID operation/method
 */
if ($get->getFullDayAbsencesByPersonID(new \StructType\GetFullDayAbsencesByPersonID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getExceptionsByDoorDBID operation/method
 */
if ($get->getExceptionsByDoorDBID(new \StructType\GetExceptionsByDoorDBID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountSumsByPersonID2 operation/method
 */
if ($get->getAccountSumsByPersonID2(new \StructType\GetAccountSumsByPersonID2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingPairsByLevels operation/method
 */
if ($get->getBookingPairsByLevels(new \StructType\GetBookingPairsByLevels()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGroupsByName operation/method
 */
if ($get->getGroupsByName(new \StructType\GetGroupsByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAttachedDocuments operation/method
 */
if ($get->getAttachedDocuments(new \StructType\GetAttachedDocuments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccounts operation/method
 */
if ($get->getAccounts(new \StructType\GetAccounts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGroupMemberships operation/method
 */
if ($get->getGroupMemberships(new \StructType\GetGroupMemberships()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTripsOfVehicle operation/method
 */
if ($get->getTripsOfVehicle(new \StructType\GetTripsOfVehicle()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGlobalLockDate operation/method
 */
if ($get->getGlobalLockDate(new \StructType\GetGlobalLockDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllEmployees operation/method
 */
if ($get->getAllEmployees(new \StructType\GetAllEmployees()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllTerminalsE operation/method
 */
if ($get->getAllTerminalsE(new \StructType\GetAllTerminalsE()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingPairs operation/method
 */
if ($get->getBookingPairs(new \StructType\GetBookingPairs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCheckedBDEBookingPairs2 operation/method
 */
if ($get->getCheckedBDEBookingPairs2(new \StructType\GetCheckedBDEBookingPairs2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingPairsByPersonDBID operation/method
 */
if ($get->getBookingPairsByPersonDBID(new \StructType\GetBookingPairsByPersonDBID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingPairsByPersonID operation/method
 */
if ($get->getBookingPairsByPersonID(new \StructType\GetBookingPairsByPersonID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEntryPeriodDefinitionsById operation/method
 */
if ($get->getEntryPeriodDefinitionsById(new \StructType\GetEntryPeriodDefinitionsById()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllLevelDefinitions operation/method
 */
if ($get->getAllLevelDefinitions(new \StructType\GetAllLevelDefinitions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllCustomersE operation/method
 */
if ($get->getAllCustomersE(new \StructType\GetAllCustomersE()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsEByLevelID operation/method
 */
if ($get->getLevelsEByLevelID(new \StructType\GetLevelsEByLevelID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCheckedBDEBookingPairs operation/method
 */
if ($get->getCheckedBDEBookingPairs(new \StructType\GetCheckedBDEBookingPairs()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllEmployeesE operation/method
 */
if ($get->getAllEmployeesE(new \StructType\GetAllEmployeesE()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountSums operation/method
 */
if ($get->getAccountSums(new \StructType\GetAccountSums()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllPersons operation/method
 */
if ($get->getAllPersons(new \StructType\GetAllPersons()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLockDateByPersonID operation/method
 */
if ($get->getLockDateByPersonID(new \StructType\GetLockDateByPersonID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelByIdentification operation/method
 */
if ($get->getLevelByIdentification(new \StructType\GetLevelByIdentification()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccountsByPersonID operation/method
 */
if ($get->getAccountsByPersonID(new \StructType\GetAccountsByPersonID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBookingPairsByLevel operation/method
 */
if ($get->getBookingPairsByLevel(new \StructType\GetBookingPairsByLevel()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTask operation/method
 */
if ($get->getTask(new \StructType\GetTask()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLevelsByIdentification operation/method
 */
if ($get->getLevelsByIdentification(new \StructType\GetLevelsByIdentification()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTrips2 operation/method
 */
if ($get->getTrips2(new \StructType\GetTrips2()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for setAbsenceBlocksByPersonID operation/method
 */
if ($set->setAbsenceBlocksByPersonID(new \StructType\SetAbsenceBlocksByPersonID()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setAccountDailyCorrectionByPersonDBID operation/method
 */
if ($set->setAccountDailyCorrectionByPersonDBID(new \StructType\SetAccountDailyCorrectionByPersonDBID()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setAccountDailyCorrectionByPersonID operation/method
 */
if ($set->setAccountDailyCorrectionByPersonID(new \StructType\SetAccountDailyCorrectionByPersonID()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setSessionOption operation/method
 */
if ($set->setSessionOption(new \StructType\SetSessionOption()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setAbsenceBlocksByPersonDBID operation/method
 */
if ($set->setAbsenceBlocksByPersonDBID(new \StructType\SetAbsenceBlocksByPersonDBID()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setAccountMonthlyCorrectionByPersonDBID operation/method
 */
if ($set->setAccountMonthlyCorrectionByPersonDBID(new \StructType\SetAccountMonthlyCorrectionByPersonDBID()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for setAccountMonthlyCorrectionByPersonID operation/method
 */
if ($set->setAccountMonthlyCorrectionByPersonID(new \StructType\SetAccountMonthlyCorrectionByPersonID()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for updateLevel operation/method
 */
if ($update->updateLevel(new \StructType\UpdateLevel()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGroups operation/method
 */
if ($update->updateGroups(new \StructType\UpdateGroups()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCustomer2 operation/method
 */
if ($update->updateCustomer2(new \StructType\UpdateCustomer2()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateConfigurationTime operation/method
 */
if ($update->updateConfigurationTime(new \StructType\UpdateConfigurationTime()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCommunicationTime operation/method
 */
if ($update->updateCommunicationTime(new \StructType\UpdateCommunicationTime()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCustomersE operation/method
 */
if ($update->updateCustomersE(new \StructType\UpdateCustomersE()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTaskAssignment operation/method
 */
if ($update->updateTaskAssignment(new \StructType\UpdateTaskAssignment()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGenericProperties operation/method
 */
if ($update->updateGenericProperties(new \StructType\UpdateGenericProperties()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCustomer operation/method
 */
if ($update->updateCustomer(new \StructType\UpdateCustomer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLevelsE operation/method
 */
if ($update->updateLevelsE(new \StructType\UpdateLevelsE()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePersonsE operation/method
 */
if ($update->updatePersonsE(new \StructType\UpdatePersonsE()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for findPersonsByTerminal operation/method
 */
if ($find->findPersonsByTerminal(new \StructType\FindPersonsByTerminal()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findAccountDefinitionsByTerminal operation/method
 */
if ($find->findAccountDefinitionsByTerminal(new \StructType\FindAccountDefinitionsByTerminal()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPropertiesByLevelDBID operation/method
 */
if ($find->findPropertiesByLevelDBID(new \StructType\FindPropertiesByLevelDBID()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCustomerLinksByLocation operation/method
 */
if ($find->findCustomerLinksByLocation(new \StructType\FindCustomerLinksByLocation()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPersonsByKeyValueE operation/method
 */
if ($find->findPersonsByKeyValueE(new \StructType\FindPersonsByKeyValueE()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findTripsByPersonDBID operation/method
 */
if ($find->findTripsByPersonDBID(new \StructType\FindTripsByPersonDBID()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findTrips2ByWSLink operation/method
 */
if ($find->findTrips2ByWSLink(new \StructType\FindTrips2ByWSLink()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPropertiesByVehicleDBID operation/method
 */
if ($find->findPropertiesByVehicleDBID(new \StructType\FindPropertiesByVehicleDBID()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findLevelsEByCustomer operation/method
 */
if ($find->findLevelsEByCustomer(new \StructType\FindLevelsEByCustomer()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCustomerByReference operation/method
 */
if ($find->findCustomerByReference(new \StructType\FindCustomerByReference()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPersonsByTerminalNr operation/method
 */
if ($find->findPersonsByTerminalNr(new \StructType\FindPersonsByTerminalNr()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findTripsByPersonID operation/method
 */
if ($find->findTripsByPersonID(new \StructType\FindTripsByPersonID()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findVehicleInBounds operation/method
 */
if ($find->findVehicleInBounds(new \StructType\FindVehicleInBounds()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findChanges operation/method
 */
if ($find->findChanges(new \StructType\FindChanges()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPropertiesByLinkTypeAndDBID operation/method
 */
if ($find->findPropertiesByLinkTypeAndDBID(new \StructType\FindPropertiesByLinkTypeAndDBID()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCustomersEByReference operation/method
 */
if ($find->findCustomersEByReference(new \StructType\FindCustomersEByReference()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPropertiesByPersonDBID operation/method
 */
if ($find->findPropertiesByPersonDBID(new \StructType\FindPropertiesByPersonDBID()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCustomersByReference operation/method
 */
if ($find->findCustomersByReference(new \StructType\FindCustomersByReference()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findPersonsByTerminalE operation/method
 */
if ($find->findPersonsByTerminalE(new \StructType\FindPersonsByTerminalE()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findAccountDefinitionssByTerminalNr operation/method
 */
if ($find->findAccountDefinitionssByTerminalNr(new \StructType\FindAccountDefinitionssByTerminalNr()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCustomersEByLocation operation/method
 */
if ($find->findCustomersEByLocation(new \StructType\FindCustomersEByLocation()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createPersonE operation/method
 */
if ($create->createPersonE(new \StructType\CreatePersonE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createLevelE operation/method
 */
if ($create->createLevelE(new \StructType\CreateLevelE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createEntryTerminal operation/method
 */
if ($create->createEntryTerminal(new \StructType\CreateEntryTerminal()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createGroup operation/method
 */
if ($create->createGroup(new \StructType\CreateGroup()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createEntryDoor operation/method
 */
if ($create->createEntryDoor(new \StructType\CreateEntryDoor()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createCustomer operation/method
 */
if ($create->createCustomer(new \StructType\CreateCustomer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPerson operation/method
 */
if ($create->createPerson(new \StructType\CreatePerson()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createGroupMemberShip operation/method
 */
if ($create->createGroupMemberShip(new \StructType\CreateGroupMemberShip()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPersonsE operation/method
 */
if ($create->createPersonsE(new \StructType\CreatePersonsE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createTerminalsE operation/method
 */
if ($create->createTerminalsE(new \StructType\CreateTerminalsE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createCustomers operation/method
 */
if ($create->createCustomers(new \StructType\CreateCustomers()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createLevelsE operation/method
 */
if ($create->createLevelsE(new \StructType\CreateLevelsE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createCustomerE operation/method
 */
if ($create->createCustomerE(new \StructType\CreateCustomerE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createTask operation/method
 */
if ($create->createTask(new \StructType\CreateTask()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createCustomersE operation/method
 */
if ($create->createCustomersE(new \StructType\CreateCustomersE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createLevels operation/method
 */
if ($create->createLevels(new \StructType\CreateLevels()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createBookingsE operation/method
 */
if ($create->createBookingsE(new \StructType\CreateBookingsE()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createLevel operation/method
 */
if ($create->createLevel(new \StructType\CreateLevel()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for modifyGroupMemberships operation/method
 */
if ($modify->modifyGroupMemberships(new \StructType\ModifyGroupMemberships()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyTasks operation/method
 */
if ($modify->modifyTasks(new \StructType\ModifyTasks()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyTrip operation/method
 */
if ($modify->modifyTrip(new \StructType\ModifyTrip()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyTrips operation/method
 */
if ($modify->modifyTrips(new \StructType\ModifyTrips()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyEntryDoors operation/method
 */
if ($modify->modifyEntryDoors(new \StructType\ModifyEntryDoors()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyLevels operation/method
 */
if ($modify->modifyLevels(new \StructType\ModifyLevels()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for modifyEntryTerminals operation/method
 */
if ($modify->modifyEntryTerminals(new \StructType\ModifyEntryTerminals()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Quick ServiceType
 */
$quick = new \ServiceType\Quick($options);
/**
 * Sample call for quickMoveGroupMember operation/method
 */
if ($quick->quickMoveGroupMember(new \StructType\QuickMoveGroupMember()) !== false) {
    print_r($quick->getResult());
} else {
    print_r($quick->getLastError());
}
/**
 * Sample call for quickAddGroupMember operation/method
 */
if ($quick->quickAddGroupMember(new \StructType\QuickAddGroupMember()) !== false) {
    print_r($quick->getResult());
} else {
    print_r($quick->getLastError());
}
/**
 * Sample call for quickDeleteGroupMember operation/method
 */
if ($quick->quickDeleteGroupMember(new \StructType\QuickDeleteGroupMember()) !== false) {
    print_r($quick->getResult());
} else {
    print_r($quick->getLastError());
}
/**
 * Samples for Open ServiceType
 */
$open = new \ServiceType\Open($options);
/**
 * Sample call for openSession1 operation/method
 */
if ($open->openSession1(new \StructType\OpenSession1()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Sample call for openSession operation/method
 */
if ($open->openSession(new \StructType\OpenSession()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for deleteFullDayBookings operation/method
 */
if ($delete->deleteFullDayBookings(new \StructType\DeleteFullDayBookings()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteTask operation/method
 */
if ($delete->deleteTask(new \StructType\DeleteTask()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteBookings operation/method
 */
if ($delete->deleteBookings(new \StructType\DeleteBookings()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteCustomersByDBID operation/method
 */
if ($delete->deleteCustomersByDBID(new \StructType\DeleteCustomersByDBID()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteCustomersByReference operation/method
 */
if ($delete->deleteCustomersByReference(new \StructType\DeleteCustomersByReference()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteGroup operation/method
 */
if ($delete->deleteGroup(new \StructType\DeleteGroup()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteAttachedDocuments operation/method
 */
if ($delete->deleteAttachedDocuments(new \StructType\DeleteAttachedDocuments()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Invoke ServiceType
 */
$invoke = new \ServiceType\Invoke($options);
/**
 * Sample call for invokeScriptedFunction operation/method
 */
if ($invoke->invokeScriptedFunction(new \StructType\InvokeScriptedFunction()) !== false) {
    print_r($invoke->getResult());
} else {
    print_r($invoke->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for importTerminalBookings2 operation/method
 */
if ($import->importTerminalBookings2(new \StructType\ImportTerminalBookings2()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for importBarcodeData2 operation/method
 */
if ($import->importBarcodeData2(new \StructType\ImportBarcodeData2()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for importBarcodeData operation/method
 */
if ($import->importBarcodeData(new \StructType\ImportBarcodeData()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for importTerminalBookings operation/method
 */
if ($import->importTerminalBookings(new \StructType\ImportTerminalBookings()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Refresh ServiceType
 */
$refresh = new \ServiceType\Refresh($options);
/**
 * Sample call for refreshSession operation/method
 */
if ($refresh->refreshSession(new \StructType\RefreshSession()) !== false) {
    print_r($refresh->getResult());
} else {
    print_r($refresh->getLastError());
}
/**
 * Samples for Bulk ServiceType
 */
$bulk = new \ServiceType\Bulk($options);
/**
 * Sample call for bulkSetAccountDailyCorrectionByPersonID operation/method
 */
if ($bulk->bulkSetAccountDailyCorrectionByPersonID(new \StructType\BulkSetAccountDailyCorrectionByPersonID()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \ServiceType\Search($options);
/**
 * Sample call for searchTasks operation/method
 */
if ($search->searchTasks(new \StructType\SearchTasks()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Clear ServiceType
 */
$clear = new \ServiceType\Clear($options);
/**
 * Sample call for clearSessionOption operation/method
 */
if ($clear->clearSessionOption(new \StructType\ClearSessionOption()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkBookings operation/method
 */
if ($check->checkBookings(new \StructType\CheckBookings()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \ServiceType\Logout($options);
/**
 * Sample call for logout operation/method
 */
if ($logout->logout(new \StructType\Logout()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for login operation/method
 */
if ($login->login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \ServiceType\Close($options);
/**
 * Sample call for closeSession operation/method
 */
if ($close->closeSession(new \StructType\CloseSession()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Perform ServiceType
 */
$perform = new \ServiceType\Perform($options);
/**
 * Sample call for performTaskAction operation/method
 */
if ($perform->performTaskAction(new \StructType\PerformTaskAction()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
