<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSLevelIdentification ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSLevelIdentification extends AbstractStructArrayBase
{
    /**
     * The WSLevelIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLevelIdentification[]
     */
    public $WSLevelIdentification;
    /**
     * Constructor method for ArrayOfWSLevelIdentification
     * @uses ArrayOfWSLevelIdentification::setWSLevelIdentification()
     * @param \StructType\WSLevelIdentification[] $wSLevelIdentification
     */
    public function __construct(array $wSLevelIdentification = array())
    {
        $this
            ->setWSLevelIdentification($wSLevelIdentification);
    }
    /**
     * Get WSLevelIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLevelIdentification[]|null
     */
    public function getWSLevelIdentification()
    {
        return isset($this->WSLevelIdentification) ? $this->WSLevelIdentification : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSLevelIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSLevelIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSLevelIdentificationForArrayConstraintsFromSetWSLevelIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSLevelIdentificationWSLevelIdentificationItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSLevelIdentificationWSLevelIdentificationItem instanceof \StructType\WSLevelIdentification) {
                $invalidValues[] = is_object($arrayOfWSLevelIdentificationWSLevelIdentificationItem) ? get_class($arrayOfWSLevelIdentificationWSLevelIdentificationItem) : sprintf('%s(%s)', gettype($arrayOfWSLevelIdentificationWSLevelIdentificationItem), var_export($arrayOfWSLevelIdentificationWSLevelIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSLevelIdentification property can only contain items of type \StructType\WSLevelIdentification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSLevelIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSLevelIdentification[] $wSLevelIdentification
     * @return \ArrayType\ArrayOfWSLevelIdentification
     */
    public function setWSLevelIdentification(array $wSLevelIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($wSLevelIdentificationArrayErrorMessage = self::validateWSLevelIdentificationForArrayConstraintsFromSetWSLevelIdentification($wSLevelIdentification))) {
            throw new \InvalidArgumentException($wSLevelIdentificationArrayErrorMessage, __LINE__);
        }
        if (is_null($wSLevelIdentification) || (is_array($wSLevelIdentification) && empty($wSLevelIdentification))) {
            unset($this->WSLevelIdentification);
        } else {
            $this->WSLevelIdentification = $wSLevelIdentification;
        }
        return $this;
    }
    /**
     * Add item to WSLevelIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\WSLevelIdentification $item
     * @return \ArrayType\ArrayOfWSLevelIdentification
     */
    public function addToWSLevelIdentification(\StructType\WSLevelIdentification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSLevelIdentification) {
            throw new \InvalidArgumentException(sprintf('The WSLevelIdentification property can only contain items of type \StructType\WSLevelIdentification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSLevelIdentification[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSLevelIdentification|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSLevelIdentification|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSLevelIdentification|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSLevelIdentification|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSLevelIdentification|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSLevelIdentification
     */
    public function getAttributeName()
    {
        return 'WSLevelIdentification';
    }
}
