<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSVehicleStatus StructType
 * @subpackage Structs
 */
class WSVehicleStatus extends AbstractStructBase
{
    /**
     * The VBatt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VBatt;
    /**
     * The driver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSPerson
     */
    public $driver;
    /**
     * The gpsFix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $gpsFix;
    /**
     * The gsmLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $gsmLevel;
    /**
     * The lastCommTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $lastCommTS;
    /**
     * The lastWaypoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSWaypoint
     */
    public $lastWaypoint;
    /**
     * The moving
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $moving;
    /**
     * The movingTS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $movingTS;
    /**
     * The privateMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $privateMode;
    /**
     * The symbolID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $symbolID;
    /**
     * The terminalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $terminalID;
    /**
     * The vehicleDBID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vehicleDBID;
    /**
     * The vehicleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $vehicleName;
    /**
     * Constructor method for WSVehicleStatus
     * @uses WSVehicleStatus::setVBatt()
     * @uses WSVehicleStatus::setDriver()
     * @uses WSVehicleStatus::setGpsFix()
     * @uses WSVehicleStatus::setGsmLevel()
     * @uses WSVehicleStatus::setLastCommTS()
     * @uses WSVehicleStatus::setLastWaypoint()
     * @uses WSVehicleStatus::setMoving()
     * @uses WSVehicleStatus::setMovingTS()
     * @uses WSVehicleStatus::setPrivateMode()
     * @uses WSVehicleStatus::setSymbolID()
     * @uses WSVehicleStatus::setTerminalID()
     * @uses WSVehicleStatus::setVehicleDBID()
     * @uses WSVehicleStatus::setVehicleName()
     * @param float $vBatt
     * @param \StructType\WSPerson $driver
     * @param bool $gpsFix
     * @param int $gsmLevel
     * @param \StructType\WSTimestamp $lastCommTS
     * @param \StructType\WSWaypoint $lastWaypoint
     * @param bool $moving
     * @param \StructType\WSTimestamp $movingTS
     * @param bool $privateMode
     * @param int $symbolID
     * @param int $terminalID
     * @param int $vehicleDBID
     * @param string $vehicleName
     */
    public function __construct($vBatt = null, \StructType\WSPerson $driver = null, $gpsFix = null, $gsmLevel = null, \StructType\WSTimestamp $lastCommTS = null, \StructType\WSWaypoint $lastWaypoint = null, $moving = null, \StructType\WSTimestamp $movingTS = null, $privateMode = null, $symbolID = null, $terminalID = null, $vehicleDBID = null, $vehicleName = null)
    {
        $this
            ->setVBatt($vBatt)
            ->setDriver($driver)
            ->setGpsFix($gpsFix)
            ->setGsmLevel($gsmLevel)
            ->setLastCommTS($lastCommTS)
            ->setLastWaypoint($lastWaypoint)
            ->setMoving($moving)
            ->setMovingTS($movingTS)
            ->setPrivateMode($privateMode)
            ->setSymbolID($symbolID)
            ->setTerminalID($terminalID)
            ->setVehicleDBID($vehicleDBID)
            ->setVehicleName($vehicleName);
    }
    /**
     * Get VBatt value
     * @return float|null
     */
    public function getVBatt()
    {
        return $this->VBatt;
    }
    /**
     * Set VBatt value
     * @param float $vBatt
     * @return \StructType\WSVehicleStatus
     */
    public function setVBatt($vBatt = null)
    {
        // validation for constraint: float
        if (!is_null($vBatt) && !(is_float($vBatt) || is_numeric($vBatt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vBatt, true), gettype($vBatt)), __LINE__);
        }
        $this->VBatt = $vBatt;
        return $this;
    }
    /**
     * Get driver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSPerson|null
     */
    public function getDriver()
    {
        return isset($this->driver) ? $this->driver : null;
    }
    /**
     * Set driver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSPerson $driver
     * @return \StructType\WSVehicleStatus
     */
    public function setDriver(\StructType\WSPerson $driver = null)
    {
        if (is_null($driver) || (is_array($driver) && empty($driver))) {
            unset($this->driver);
        } else {
            $this->driver = $driver;
        }
        return $this;
    }
    /**
     * Get gpsFix value
     * @return bool|null
     */
    public function getGpsFix()
    {
        return $this->gpsFix;
    }
    /**
     * Set gpsFix value
     * @param bool $gpsFix
     * @return \StructType\WSVehicleStatus
     */
    public function setGpsFix($gpsFix = null)
    {
        // validation for constraint: boolean
        if (!is_null($gpsFix) && !is_bool($gpsFix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gpsFix, true), gettype($gpsFix)), __LINE__);
        }
        $this->gpsFix = $gpsFix;
        return $this;
    }
    /**
     * Get gsmLevel value
     * @return int|null
     */
    public function getGsmLevel()
    {
        return $this->gsmLevel;
    }
    /**
     * Set gsmLevel value
     * @param int $gsmLevel
     * @return \StructType\WSVehicleStatus
     */
    public function setGsmLevel($gsmLevel = null)
    {
        // validation for constraint: int
        if (!is_null($gsmLevel) && !(is_int($gsmLevel) || ctype_digit($gsmLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gsmLevel, true), gettype($gsmLevel)), __LINE__);
        }
        $this->gsmLevel = $gsmLevel;
        return $this;
    }
    /**
     * Get lastCommTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getLastCommTS()
    {
        return isset($this->lastCommTS) ? $this->lastCommTS : null;
    }
    /**
     * Set lastCommTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $lastCommTS
     * @return \StructType\WSVehicleStatus
     */
    public function setLastCommTS(\StructType\WSTimestamp $lastCommTS = null)
    {
        if (is_null($lastCommTS) || (is_array($lastCommTS) && empty($lastCommTS))) {
            unset($this->lastCommTS);
        } else {
            $this->lastCommTS = $lastCommTS;
        }
        return $this;
    }
    /**
     * Get lastWaypoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSWaypoint|null
     */
    public function getLastWaypoint()
    {
        return isset($this->lastWaypoint) ? $this->lastWaypoint : null;
    }
    /**
     * Set lastWaypoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSWaypoint $lastWaypoint
     * @return \StructType\WSVehicleStatus
     */
    public function setLastWaypoint(\StructType\WSWaypoint $lastWaypoint = null)
    {
        if (is_null($lastWaypoint) || (is_array($lastWaypoint) && empty($lastWaypoint))) {
            unset($this->lastWaypoint);
        } else {
            $this->lastWaypoint = $lastWaypoint;
        }
        return $this;
    }
    /**
     * Get moving value
     * @return bool|null
     */
    public function getMoving()
    {
        return $this->moving;
    }
    /**
     * Set moving value
     * @param bool $moving
     * @return \StructType\WSVehicleStatus
     */
    public function setMoving($moving = null)
    {
        // validation for constraint: boolean
        if (!is_null($moving) && !is_bool($moving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($moving, true), gettype($moving)), __LINE__);
        }
        $this->moving = $moving;
        return $this;
    }
    /**
     * Get movingTS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getMovingTS()
    {
        return isset($this->movingTS) ? $this->movingTS : null;
    }
    /**
     * Set movingTS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $movingTS
     * @return \StructType\WSVehicleStatus
     */
    public function setMovingTS(\StructType\WSTimestamp $movingTS = null)
    {
        if (is_null($movingTS) || (is_array($movingTS) && empty($movingTS))) {
            unset($this->movingTS);
        } else {
            $this->movingTS = $movingTS;
        }
        return $this;
    }
    /**
     * Get privateMode value
     * @return bool|null
     */
    public function getPrivateMode()
    {
        return $this->privateMode;
    }
    /**
     * Set privateMode value
     * @param bool $privateMode
     * @return \StructType\WSVehicleStatus
     */
    public function setPrivateMode($privateMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($privateMode) && !is_bool($privateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($privateMode, true), gettype($privateMode)), __LINE__);
        }
        $this->privateMode = $privateMode;
        return $this;
    }
    /**
     * Get symbolID value
     * @return int|null
     */
    public function getSymbolID()
    {
        return $this->symbolID;
    }
    /**
     * Set symbolID value
     * @param int $symbolID
     * @return \StructType\WSVehicleStatus
     */
    public function setSymbolID($symbolID = null)
    {
        // validation for constraint: int
        if (!is_null($symbolID) && !(is_int($symbolID) || ctype_digit($symbolID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($symbolID, true), gettype($symbolID)), __LINE__);
        }
        $this->symbolID = $symbolID;
        return $this;
    }
    /**
     * Get terminalID value
     * @return int|null
     */
    public function getTerminalID()
    {
        return $this->terminalID;
    }
    /**
     * Set terminalID value
     * @param int $terminalID
     * @return \StructType\WSVehicleStatus
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: int
        if (!is_null($terminalID) && !(is_int($terminalID) || ctype_digit($terminalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalID, true), gettype($terminalID)), __LINE__);
        }
        $this->terminalID = $terminalID;
        return $this;
    }
    /**
     * Get vehicleDBID value
     * @return int|null
     */
    public function getVehicleDBID()
    {
        return $this->vehicleDBID;
    }
    /**
     * Set vehicleDBID value
     * @param int $vehicleDBID
     * @return \StructType\WSVehicleStatus
     */
    public function setVehicleDBID($vehicleDBID = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleDBID) && !(is_int($vehicleDBID) || ctype_digit($vehicleDBID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleDBID, true), gettype($vehicleDBID)), __LINE__);
        }
        $this->vehicleDBID = $vehicleDBID;
        return $this;
    }
    /**
     * Get vehicleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVehicleName()
    {
        return isset($this->vehicleName) ? $this->vehicleName : null;
    }
    /**
     * Set vehicleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vehicleName
     * @return \StructType\WSVehicleStatus
     */
    public function setVehicleName($vehicleName = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleName) && !is_string($vehicleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleName, true), gettype($vehicleName)), __LINE__);
        }
        if (is_null($vehicleName) || (is_array($vehicleName) && empty($vehicleName))) {
            unset($this->vehicleName);
        } else {
            $this->vehicleName = $vehicleName;
        }
        return $this;
    }
}
