<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSVehicle StructType
 * @subpackage Structs
 */
class WSVehicle extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The brandType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $brandType;
    /**
     * The defaultDriver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSLink
     */
    public $defaultDriver;
    /**
     * The licensePlate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $licensePlate;
    /**
     * The manufactureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSTimestamp
     */
    public $manufactureDate;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The online
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $online;
    /**
     * The registeredTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $registeredTo;
    /**
     * The symbolID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $symbolID;
    /**
     * The terminalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $terminalID;
    /**
     * Constructor method for WSVehicle
     * @uses WSVehicle::setID()
     * @uses WSVehicle::setBrandType()
     * @uses WSVehicle::setDefaultDriver()
     * @uses WSVehicle::setLicensePlate()
     * @uses WSVehicle::setManufactureDate()
     * @uses WSVehicle::setName()
     * @uses WSVehicle::setOnline()
     * @uses WSVehicle::setRegisteredTo()
     * @uses WSVehicle::setSymbolID()
     * @uses WSVehicle::setTerminalID()
     * @param int $iD
     * @param string $brandType
     * @param \StructType\WSLink $defaultDriver
     * @param string $licensePlate
     * @param \StructType\WSTimestamp $manufactureDate
     * @param string $name
     * @param bool $online
     * @param string $registeredTo
     * @param int $symbolID
     * @param int $terminalID
     */
    public function __construct($iD = null, $brandType = null, \StructType\WSLink $defaultDriver = null, $licensePlate = null, \StructType\WSTimestamp $manufactureDate = null, $name = null, $online = null, $registeredTo = null, $symbolID = null, $terminalID = null)
    {
        $this
            ->setID($iD)
            ->setBrandType($brandType)
            ->setDefaultDriver($defaultDriver)
            ->setLicensePlate($licensePlate)
            ->setManufactureDate($manufactureDate)
            ->setName($name)
            ->setOnline($online)
            ->setRegisteredTo($registeredTo)
            ->setSymbolID($symbolID)
            ->setTerminalID($terminalID);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WSVehicle
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get brandType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrandType()
    {
        return isset($this->brandType) ? $this->brandType : null;
    }
    /**
     * Set brandType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brandType
     * @return \StructType\WSVehicle
     */
    public function setBrandType($brandType = null)
    {
        // validation for constraint: string
        if (!is_null($brandType) && !is_string($brandType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandType, true), gettype($brandType)), __LINE__);
        }
        if (is_null($brandType) || (is_array($brandType) && empty($brandType))) {
            unset($this->brandType);
        } else {
            $this->brandType = $brandType;
        }
        return $this;
    }
    /**
     * Get defaultDriver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSLink|null
     */
    public function getDefaultDriver()
    {
        return isset($this->defaultDriver) ? $this->defaultDriver : null;
    }
    /**
     * Set defaultDriver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSLink $defaultDriver
     * @return \StructType\WSVehicle
     */
    public function setDefaultDriver(\StructType\WSLink $defaultDriver = null)
    {
        if (is_null($defaultDriver) || (is_array($defaultDriver) && empty($defaultDriver))) {
            unset($this->defaultDriver);
        } else {
            $this->defaultDriver = $defaultDriver;
        }
        return $this;
    }
    /**
     * Get licensePlate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLicensePlate()
    {
        return isset($this->licensePlate) ? $this->licensePlate : null;
    }
    /**
     * Set licensePlate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $licensePlate
     * @return \StructType\WSVehicle
     */
    public function setLicensePlate($licensePlate = null)
    {
        // validation for constraint: string
        if (!is_null($licensePlate) && !is_string($licensePlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licensePlate, true), gettype($licensePlate)), __LINE__);
        }
        if (is_null($licensePlate) || (is_array($licensePlate) && empty($licensePlate))) {
            unset($this->licensePlate);
        } else {
            $this->licensePlate = $licensePlate;
        }
        return $this;
    }
    /**
     * Get manufactureDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSTimestamp|null
     */
    public function getManufactureDate()
    {
        return isset($this->manufactureDate) ? $this->manufactureDate : null;
    }
    /**
     * Set manufactureDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\WSTimestamp $manufactureDate
     * @return \StructType\WSVehicle
     */
    public function setManufactureDate(\StructType\WSTimestamp $manufactureDate = null)
    {
        if (is_null($manufactureDate) || (is_array($manufactureDate) && empty($manufactureDate))) {
            unset($this->manufactureDate);
        } else {
            $this->manufactureDate = $manufactureDate;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSVehicle
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get online value
     * @return bool|null
     */
    public function getOnline()
    {
        return $this->online;
    }
    /**
     * Set online value
     * @param bool $online
     * @return \StructType\WSVehicle
     */
    public function setOnline($online = null)
    {
        // validation for constraint: boolean
        if (!is_null($online) && !is_bool($online)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($online, true), gettype($online)), __LINE__);
        }
        $this->online = $online;
        return $this;
    }
    /**
     * Get registeredTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegisteredTo()
    {
        return isset($this->registeredTo) ? $this->registeredTo : null;
    }
    /**
     * Set registeredTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registeredTo
     * @return \StructType\WSVehicle
     */
    public function setRegisteredTo($registeredTo = null)
    {
        // validation for constraint: string
        if (!is_null($registeredTo) && !is_string($registeredTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registeredTo, true), gettype($registeredTo)), __LINE__);
        }
        if (is_null($registeredTo) || (is_array($registeredTo) && empty($registeredTo))) {
            unset($this->registeredTo);
        } else {
            $this->registeredTo = $registeredTo;
        }
        return $this;
    }
    /**
     * Get symbolID value
     * @return int|null
     */
    public function getSymbolID()
    {
        return $this->symbolID;
    }
    /**
     * Set symbolID value
     * @param int $symbolID
     * @return \StructType\WSVehicle
     */
    public function setSymbolID($symbolID = null)
    {
        // validation for constraint: int
        if (!is_null($symbolID) && !(is_int($symbolID) || ctype_digit($symbolID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($symbolID, true), gettype($symbolID)), __LINE__);
        }
        $this->symbolID = $symbolID;
        return $this;
    }
    /**
     * Get terminalID value
     * @return int|null
     */
    public function getTerminalID()
    {
        return $this->terminalID;
    }
    /**
     * Set terminalID value
     * @param int $terminalID
     * @return \StructType\WSVehicle
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: int
        if (!is_null($terminalID) && !(is_int($terminalID) || ctype_digit($terminalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalID, true), gettype($terminalID)), __LINE__);
        }
        $this->terminalID = $terminalID;
        return $this;
    }
}
