<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bulk ServiceType
 * @subpackage Services
 */
class Bulk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * bulkSetAccountDailyCorrectionByPersonID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BulkSetAccountDailyCorrectionByPersonID $parameters
     * @return \StructType\BulkSetAccountDailyCorrectionByPersonIDResponse|bool
     */
    public function bulkSetAccountDailyCorrectionByPersonID(\StructType\BulkSetAccountDailyCorrectionByPersonID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->bulkSetAccountDailyCorrectionByPersonID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BulkSetAccountDailyCorrectionByPersonIDResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
