<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSChange ArrayType
 * @subpackage Arrays
 */
class ArrayOfWSChange extends AbstractStructArrayBase
{
    /**
     * The WSChange
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WSChange[]
     */
    public $WSChange;
    /**
     * Constructor method for ArrayOfWSChange
     * @uses ArrayOfWSChange::setWSChange()
     * @param \StructType\WSChange[] $wSChange
     */
    public function __construct(array $wSChange = array())
    {
        $this
            ->setWSChange($wSChange);
    }
    /**
     * Get WSChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WSChange[]|null
     */
    public function getWSChange()
    {
        return isset($this->WSChange) ? $this->WSChange : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWSChange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWSChange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWSChangeForArrayConstraintsFromSetWSChange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWSChangeWSChangeItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSChangeWSChangeItem instanceof \StructType\WSChange) {
                $invalidValues[] = is_object($arrayOfWSChangeWSChangeItem) ? get_class($arrayOfWSChangeWSChangeItem) : sprintf('%s(%s)', gettype($arrayOfWSChangeWSChangeItem), var_export($arrayOfWSChangeWSChangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WSChange property can only contain items of type \StructType\WSChange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WSChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WSChange[] $wSChange
     * @return \ArrayType\ArrayOfWSChange
     */
    public function setWSChange(array $wSChange = array())
    {
        // validation for constraint: array
        if ('' !== ($wSChangeArrayErrorMessage = self::validateWSChangeForArrayConstraintsFromSetWSChange($wSChange))) {
            throw new \InvalidArgumentException($wSChangeArrayErrorMessage, __LINE__);
        }
        if (is_null($wSChange) || (is_array($wSChange) && empty($wSChange))) {
            unset($this->WSChange);
        } else {
            $this->WSChange = $wSChange;
        }
        return $this;
    }
    /**
     * Add item to WSChange value
     * @throws \InvalidArgumentException
     * @param \StructType\WSChange $item
     * @return \ArrayType\ArrayOfWSChange
     */
    public function addToWSChange(\StructType\WSChange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WSChange) {
            throw new \InvalidArgumentException(sprintf('The WSChange property can only contain items of type \StructType\WSChange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WSChange[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WSChange|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WSChange|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WSChange|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WSChange|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WSChange|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSChange
     */
    public function getAttributeName()
    {
        return 'WSChange';
    }
}
