<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSAccountDefinition StructType
 * @subpackage Structs
 */
class WSAccountDefinition extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The abbreviation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abbreviation;
    /**
     * The continuous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $continuous;
    /**
     * The divisor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $divisor;
    /**
     * The format
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $format;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unit;
    /**
     * The vacation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vacation;
    /**
     * Constructor method for WSAccountDefinition
     * @uses WSAccountDefinition::setID()
     * @uses WSAccountDefinition::setAbbreviation()
     * @uses WSAccountDefinition::setContinuous()
     * @uses WSAccountDefinition::setDivisor()
     * @uses WSAccountDefinition::setFormat()
     * @uses WSAccountDefinition::setName()
     * @uses WSAccountDefinition::setUnit()
     * @uses WSAccountDefinition::setVacation()
     * @param int $iD
     * @param string $abbreviation
     * @param bool $continuous
     * @param int $divisor
     * @param string $format
     * @param string $name
     * @param string $unit
     * @param bool $vacation
     */
    public function __construct($iD = null, $abbreviation = null, $continuous = null, $divisor = null, $format = null, $name = null, $unit = null, $vacation = null)
    {
        $this
            ->setID($iD)
            ->setAbbreviation($abbreviation)
            ->setContinuous($continuous)
            ->setDivisor($divisor)
            ->setFormat($format)
            ->setName($name)
            ->setUnit($unit)
            ->setVacation($vacation);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WSAccountDefinition
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get abbreviation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbbreviation()
    {
        return isset($this->abbreviation) ? $this->abbreviation : null;
    }
    /**
     * Set abbreviation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abbreviation
     * @return \StructType\WSAccountDefinition
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abbreviation, true), gettype($abbreviation)), __LINE__);
        }
        if (is_null($abbreviation) || (is_array($abbreviation) && empty($abbreviation))) {
            unset($this->abbreviation);
        } else {
            $this->abbreviation = $abbreviation;
        }
        return $this;
    }
    /**
     * Get continuous value
     * @return bool|null
     */
    public function getContinuous()
    {
        return $this->continuous;
    }
    /**
     * Set continuous value
     * @param bool $continuous
     * @return \StructType\WSAccountDefinition
     */
    public function setContinuous($continuous = null)
    {
        // validation for constraint: boolean
        if (!is_null($continuous) && !is_bool($continuous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($continuous, true), gettype($continuous)), __LINE__);
        }
        $this->continuous = $continuous;
        return $this;
    }
    /**
     * Get divisor value
     * @return int|null
     */
    public function getDivisor()
    {
        return $this->divisor;
    }
    /**
     * Set divisor value
     * @param int $divisor
     * @return \StructType\WSAccountDefinition
     */
    public function setDivisor($divisor = null)
    {
        // validation for constraint: int
        if (!is_null($divisor) && !(is_int($divisor) || ctype_digit($divisor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($divisor, true), gettype($divisor)), __LINE__);
        }
        $this->divisor = $divisor;
        return $this;
    }
    /**
     * Get format value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormat()
    {
        return isset($this->format) ? $this->format : null;
    }
    /**
     * Set format value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $format
     * @return \StructType\WSAccountDefinition
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        if (is_null($format) || (is_array($format) && empty($format))) {
            unset($this->format);
        } else {
            $this->format = $format;
        }
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WSAccountDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get unit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnit()
    {
        return isset($this->unit) ? $this->unit : null;
    }
    /**
     * Set unit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unit
     * @return \StructType\WSAccountDefinition
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        if (is_null($unit) || (is_array($unit) && empty($unit))) {
            unset($this->unit);
        } else {
            $this->unit = $unit;
        }
        return $this;
    }
    /**
     * Get vacation value
     * @return bool|null
     */
    public function getVacation()
    {
        return $this->vacation;
    }
    /**
     * Set vacation value
     * @param bool $vacation
     * @return \StructType\WSAccountDefinition
     */
    public function setVacation($vacation = null)
    {
        // validation for constraint: boolean
        if (!is_null($vacation) && !is_bool($vacation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vacation, true), gettype($vacation)), __LINE__);
        }
        $this->vacation = $vacation;
        return $this;
    }
}
